/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.EntityAction;
import org.hibernate.cache.CacheKey;
import org.hibernate.cache.entry.CacheEntry;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.PostInsertEvent;
import org.hibernate.event.PreInsertEvent;
import org.hibernate.persister.entity.EntityPersister;

public final class EntityInsertAction
extends EntityAction {
    private final Object[] state;
    private Object cacheEntry;
    private final Object version;

    public EntityInsertAction(Serializable id, Object[] state, Object instance, Object version, EntityPersister persister, SessionImplementor session) throws HibernateException {
        super(session, id, instance, persister);
        this.state = state;
        this.version = version;
    }

    public void execute() throws HibernateException {
        EntityEntry entry;
        EntityPersister persister = this.getPersister();
        SessionImplementor session = this.getSession();
        Object instance = this.getInstance();
        Serializable id = this.getId();
        PreInsertEvent preEvent = new PreInsertEvent(instance, id, this.state, persister, session);
        boolean veto = session.getListeners().getPreInsertEventListener().onPreInsert(preEvent);
        if (!veto) {
            persister.insert(id, this.state, instance, session);
        }
        if ((entry = session.getPersistenceContext().getEntry(instance)) == null) {
            throw new AssertionFailure("possible nonthreadsafe access to session");
        }
        entry.setExistsInDatabase(true);
        SessionFactoryImplementor factory = this.getSession().getFactory();
        if (this.isCachePutEnabled(persister, session)) {
            CacheEntry ce = new CacheEntry(this.state, persister, persister.hasUninitializedLazyProperties(instance, session.getEntityMode()), session, instance);
            this.cacheEntry = persister.getCacheEntryStructure().structure(ce);
            CacheKey ck = new CacheKey(id, persister.getIdentifierType(), persister.getRootEntityName(), session.getEntityMode());
            boolean put = persister.getCache().insert(ck, this.cacheEntry);
            if (put && factory.getStatistics().isStatisticsEnabled()) {
                factory.getStatisticsImplementor().secondLevelCachePut(this.getPersister().getCache().getRegionName());
            }
        }
        PostInsertEvent postEvent = new PostInsertEvent(instance, id, this.state, persister, session);
        session.getListeners().getPostInsertEventListener().onPostInsert(postEvent);
        if (factory.getStatistics().isStatisticsEnabled() && !veto) {
            factory.getStatisticsImplementor().insertEntity(this.getPersister().getEntityName());
        }
    }

    public void afterTransactionCompletion(boolean success) throws HibernateException {
        EntityPersister persister = this.getPersister();
        if (success && this.isCachePutEnabled(persister, this.getSession())) {
            CacheKey ck = new CacheKey(this.getId(), persister.getIdentifierType(), persister.getRootEntityName(), this.getSession().getEntityMode());
            boolean put = persister.getCache().afterInsert(ck, this.cacheEntry, this.version);
            if (put && this.getSession().getFactory().getStatistics().isStatisticsEnabled()) {
                this.getSession().getFactory().getStatisticsImplementor().secondLevelCachePut(this.getPersister().getCache().getRegionName());
            }
        }
    }

    private boolean isCachePutEnabled(EntityPersister persister, SessionImplementor session) {
        return persister.hasCache() && !persister.isCacheInvalidationRequired() && session.getCacheMode().isPutEnabled();
    }
}

