/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.cache.CacheProvider;
import org.hibernate.cache.NoCacheProvider;
import org.hibernate.cache.QueryCacheFactory;
import org.hibernate.cfg.Environment;
import org.hibernate.cfg.Settings;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.connection.ConnectionProviderFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.exception.SQLExceptionConverter;
import org.hibernate.exception.SQLExceptionConverterFactory;
import org.hibernate.hql.QueryTranslatorFactory;
import org.hibernate.jdbc.BatcherFactory;
import org.hibernate.jdbc.BatchingBatcherFactory;
import org.hibernate.jdbc.NonBatchingBatcherFactory;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.transaction.TransactionFactoryFactory;
import org.hibernate.transaction.TransactionManagerLookup;
import org.hibernate.transaction.TransactionManagerLookupFactory;
import org.hibernate.util.PropertiesHelper;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;

public class SettingsFactory
implements Serializable {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$cfg$SettingsFactory == null ? (class$org$hibernate$cfg$SettingsFactory = SettingsFactory.class$("org.hibernate.cfg.SettingsFactory")) : class$org$hibernate$cfg$SettingsFactory));
    private static final Properties DIALECTS = new Properties();
    static /* synthetic */ Class class$org$hibernate$cfg$SettingsFactory;
    static /* synthetic */ Class class$java$sql$DatabaseMetaData;

    protected SettingsFactory() throws HibernateException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Settings buildSettings(Properties props) {
        SQLExceptionConverter sqlExceptionConverter;
        ConnectionReleaseMode releaseMode;
        Settings settings = new Settings();
        String sessionFactoryName = props.getProperty("hibernate.session_factory_name");
        settings.setSessionFactoryName(sessionFactoryName);
        ConnectionProvider connections = this.createConnectionProvider(props);
        settings.setConnectionProvider(connections);
        boolean metaSupportsScrollable = false;
        boolean metaSupportsGetGeneratedKeys = false;
        boolean metaSupportsBatchUpdates = false;
        String databaseName = null;
        try {
            Connection conn = connections.getConnection();
            try {
                DatabaseMetaData meta = conn.getMetaData();
                databaseName = meta.getDatabaseProductName();
                log.info((Object)("RDBMS: " + databaseName + ", version: " + meta.getDatabaseProductVersion()));
                log.info((Object)("JDBC driver: " + meta.getDriverName() + ", version: " + meta.getDriverVersion()));
                metaSupportsScrollable = meta.supportsResultSetType(1004);
                metaSupportsBatchUpdates = meta.supportsBatchUpdates();
                if (Environment.jvmSupportsGetGeneratedKeys()) {
                    try {
                        Boolean result = (Boolean)(class$java$sql$DatabaseMetaData == null ? (class$java$sql$DatabaseMetaData = SettingsFactory.class$("java.sql.DatabaseMetaData")) : class$java$sql$DatabaseMetaData).getMethod("supportsGetGeneratedKeys", null).invoke((Object)meta, null);
                        metaSupportsGetGeneratedKeys = result;
                    }
                    catch (AbstractMethodError ame) {
                        metaSupportsGetGeneratedKeys = false;
                    }
                    catch (Exception e) {
                        metaSupportsGetGeneratedKeys = false;
                    }
                }
            }
            finally {
                connections.closeConnection(conn);
            }
        }
        catch (SQLException sqle) {
            log.warn((Object)"Could not obtain connection metadata", (Throwable)sqle);
        }
        catch (UnsupportedOperationException uoe) {
            // empty catch block
        }
        if (props.getProperty("hibernate.dialect") == null) {
            props.setProperty("hibernate.dialect", DIALECTS.getProperty(databaseName));
        }
        Dialect dialect = Dialect.getDialect(props);
        settings.setDialect(dialect);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)dialect.getDefaultProperties());
        properties.putAll((Map<?, ?>)props);
        TransactionFactory transactionFactory = this.createTransactionFactory(properties);
        settings.setTransactionFactory(transactionFactory);
        settings.setTransactionManagerLookup(this.createTransactionManagerLookup(properties));
        boolean flushBeforeCompletion = PropertiesHelper.getBoolean("hibernate.transaction.flush_before_completion", properties);
        log.info((Object)("Automatic flush during beforeCompletion(): " + SettingsFactory.enabledDisabled(flushBeforeCompletion)));
        settings.setFlushBeforeCompletionEnabled(flushBeforeCompletion);
        boolean autoCloseSession = PropertiesHelper.getBoolean("hibernate.transaction.auto_close_session", properties);
        log.info((Object)("Automatic session close at end of transaction: " + SettingsFactory.enabledDisabled(autoCloseSession)));
        settings.setAutoCloseSessionEnabled(autoCloseSession);
        int batchSize = PropertiesHelper.getInt("hibernate.jdbc.batch_size", properties, 0);
        if (!metaSupportsBatchUpdates) {
            batchSize = 0;
        }
        if (batchSize > 0) {
            log.info((Object)("JDBC batch size: " + batchSize));
        }
        settings.setJdbcBatchSize(batchSize);
        boolean jdbcBatchVersionedData = PropertiesHelper.getBoolean("hibernate.jdbc.batch_versioned_data", properties, false);
        if (batchSize > 0) {
            log.info((Object)("JDBC batch updates for versioned data: " + SettingsFactory.enabledDisabled(jdbcBatchVersionedData)));
        }
        settings.setJdbcBatchVersionedData(jdbcBatchVersionedData);
        settings.setBatcherFactory(this.createBatcherFactory(properties, batchSize));
        boolean useScrollableResultSets = PropertiesHelper.getBoolean("hibernate.jdbc.use_scrollable_resultset", properties, metaSupportsScrollable);
        log.info((Object)("Scrollable result sets: " + SettingsFactory.enabledDisabled(useScrollableResultSets)));
        settings.setScrollableResultSetsEnabled(useScrollableResultSets);
        boolean wrapResultSets = PropertiesHelper.getBoolean("hibernate.jdbc.wrap_result_sets", properties, false);
        log.debug((Object)("Wrap result sets: " + SettingsFactory.enabledDisabled(wrapResultSets)));
        settings.setWrapResultSetsEnabled(wrapResultSets);
        boolean useGetGeneratedKeys = PropertiesHelper.getBoolean("hibernate.jdbc.use_get_generated_keys", properties, metaSupportsGetGeneratedKeys);
        log.info((Object)("JDBC3 getGeneratedKeys(): " + SettingsFactory.enabledDisabled(useGetGeneratedKeys)));
        settings.setGetGeneratedKeysEnabled(useGetGeneratedKeys);
        Integer statementFetchSize = PropertiesHelper.getInteger("hibernate.jdbc.fetch_size", properties);
        if (statementFetchSize != null) {
            log.info((Object)("JDBC result set fetch size: " + statementFetchSize));
        }
        settings.setJdbcFetchSize(statementFetchSize);
        String releaseModeName = properties.getProperty("hibernate.connection.release_mode");
        log.info((Object)("Connection release mode: " + releaseModeName));
        if ("auto".equals(releaseModeName)) {
            releaseMode = transactionFactory.getDefaultReleaseMode();
        } else {
            releaseMode = ConnectionReleaseMode.parse(releaseModeName);
            if (releaseMode == ConnectionReleaseMode.AFTER_STATEMENT && !connections.supportsAggressiveRelease()) {
                log.warn((Object)"Overriding release mode as connection provider does not support 'after_statement'");
                releaseMode = ConnectionReleaseMode.AFTER_TRANSACTION;
            }
        }
        settings.setConnectionReleaseMode(releaseMode);
        String defaultSchema = properties.getProperty("hibernate.default_schema");
        String defaultCatalog = properties.getProperty("hibernate.default_catalog");
        if (defaultSchema != null) {
            log.info((Object)("Default schema: " + defaultSchema));
        }
        if (defaultCatalog != null) {
            log.info((Object)("Default catalog: " + defaultCatalog));
        }
        settings.setDefaultSchemaName(defaultSchema);
        settings.setDefaultCatalogName(defaultCatalog);
        Integer maxFetchDepth = PropertiesHelper.getInteger("hibernate.max_fetch_depth", properties);
        if (maxFetchDepth != null) {
            log.info((Object)("Maximum outer join fetch depth: " + maxFetchDepth));
        }
        settings.setMaximumFetchDepth(maxFetchDepth);
        int batchFetchSize = PropertiesHelper.getInt("hibernate.default_batch_fetch_size", properties, 1);
        log.info((Object)("Default batch fetch size: " + batchFetchSize));
        settings.setDefaultBatchFetchSize(batchFetchSize);
        boolean comments = PropertiesHelper.getBoolean("hibernate.use_sql_comments", properties);
        log.info((Object)("Generate SQL with comments: " + SettingsFactory.enabledDisabled(comments)));
        settings.setCommentsEnabled(comments);
        boolean orderUpdates = PropertiesHelper.getBoolean("hibernate.order_updates", properties);
        log.info((Object)("Order SQL updates by primary key: " + SettingsFactory.enabledDisabled(orderUpdates)));
        settings.setOrderUpdatesEnabled(orderUpdates);
        settings.setQueryTranslatorFactory(this.createQueryTranslatorFactory(properties));
        Map querySubstitutions = PropertiesHelper.toMap("hibernate.query.substitutions", " ,=;:\n\t\r\f", properties);
        log.info((Object)("Query language substitutions: " + querySubstitutions));
        settings.setQuerySubstitutions(querySubstitutions);
        boolean useSecondLevelCache = PropertiesHelper.getBoolean("hibernate.cache.use_second_level_cache", properties, true);
        log.info((Object)("Second-level cache: " + SettingsFactory.enabledDisabled(useSecondLevelCache)));
        settings.setSecondLevelCacheEnabled(useSecondLevelCache);
        boolean useQueryCache = PropertiesHelper.getBoolean("hibernate.cache.use_query_cache", properties);
        log.info((Object)("Query cache: " + SettingsFactory.enabledDisabled(useQueryCache)));
        settings.setQueryCacheEnabled(useQueryCache);
        if (useSecondLevelCache || useQueryCache) {
            settings.setCacheProvider(this.createCacheProvider(properties));
        } else {
            settings.setCacheProvider(new NoCacheProvider());
        }
        boolean useMinimalPuts = PropertiesHelper.getBoolean("hibernate.cache.use_minimal_puts", properties, settings.getCacheProvider().isMinimalPutsEnabledByDefault());
        log.info((Object)("Optimize cache for minimal puts: " + SettingsFactory.enabledDisabled(useMinimalPuts)));
        settings.setMinimalPutsEnabled(useMinimalPuts);
        String prefix = properties.getProperty("hibernate.cache.region_prefix");
        if (StringHelper.isEmpty(prefix)) {
            prefix = null;
        }
        if (prefix != null) {
            log.info((Object)("Cache region prefix: " + prefix));
        }
        settings.setCacheRegionPrefix(prefix);
        boolean useStructuredCacheEntries = PropertiesHelper.getBoolean("hibernate.cache.use_structured_entries", properties, false);
        log.info((Object)("Structured second-level cache entries: " + SettingsFactory.enabledDisabled(useSecondLevelCache)));
        settings.setStructuredCacheEntriesEnabled(useStructuredCacheEntries);
        if (useQueryCache) {
            settings.setQueryCacheFactory(this.createQueryCacheFactory(properties));
        }
        try {
            sqlExceptionConverter = SQLExceptionConverterFactory.buildSQLExceptionConverter(dialect, properties);
        }
        catch (HibernateException e) {
            log.warn((Object)"Error building SQLExceptionConverter; using minimal converter");
            sqlExceptionConverter = SQLExceptionConverterFactory.buildMinimalSQLExceptionConverter();
        }
        settings.setSQLExceptionConverter(sqlExceptionConverter);
        boolean showSql = PropertiesHelper.getBoolean("hibernate.show_sql", properties);
        if (showSql) {
            log.info((Object)"Echoing all SQL to stdout");
        }
        settings.setShowSqlEnabled(showSql);
        boolean useStatistics = PropertiesHelper.getBoolean("hibernate.generate_statistics", properties);
        log.info((Object)("Statistics: " + SettingsFactory.enabledDisabled(useStatistics)));
        settings.setStatisticsEnabled(useStatistics);
        boolean useIdentifierRollback = PropertiesHelper.getBoolean("hibernate.use_identifier_rollback", properties);
        log.info((Object)("Deleted entity synthetic identifier rollback: " + SettingsFactory.enabledDisabled(useIdentifierRollback)));
        settings.setIdentifierRollbackEnabled(useIdentifierRollback);
        String autoSchemaExport = properties.getProperty("hibernate.hbm2ddl.auto");
        if ("update".equals(autoSchemaExport)) {
            settings.setAutoUpdateSchema(true);
        }
        if ("create".equals(autoSchemaExport)) {
            settings.setAutoCreateSchema(true);
        }
        if ("create-drop".equals(autoSchemaExport)) {
            settings.setAutoCreateSchema(true);
            settings.setAutoDropSchema(true);
        }
        EntityMode defaultEntityMode = EntityMode.parse(properties.getProperty("hibernate.default_entity_mode"));
        log.info((Object)("Default entity-mode: " + defaultEntityMode));
        settings.setDefaultEntityMode(defaultEntityMode);
        return settings;
    }

    private static final String enabledDisabled(boolean value) {
        return value ? "enabled" : "disabled";
    }

    protected QueryCacheFactory createQueryCacheFactory(Properties properties) {
        String queryCacheFactoryClassName = PropertiesHelper.getString("hibernate.cache.query_cache_factory", properties, "org.hibernate.cache.StandardQueryCacheFactory");
        log.info((Object)("Query cache factory: " + queryCacheFactoryClassName));
        try {
            return (QueryCacheFactory)ReflectHelper.classForName(queryCacheFactoryClassName).newInstance();
        }
        catch (Exception cnfe) {
            throw new HibernateException("could not instantiate QueryCacheFactory: " + queryCacheFactoryClassName, cnfe);
        }
    }

    protected CacheProvider createCacheProvider(Properties properties) {
        String cacheClassName = PropertiesHelper.getString("hibernate.cache.provider_class", properties, "org.hibernate.cache.EhCacheProvider");
        log.info((Object)("Cache provider: " + cacheClassName));
        try {
            return (CacheProvider)ReflectHelper.classForName(cacheClassName).newInstance();
        }
        catch (Exception cnfe) {
            throw new HibernateException("could not instantiate CacheProvider: " + cacheClassName, cnfe);
        }
    }

    protected QueryTranslatorFactory createQueryTranslatorFactory(Properties properties) {
        String className = PropertiesHelper.getString("hibernate.query.factory_class", properties, "org.hibernate.hql.ast.ASTQueryTranslatorFactory");
        log.info((Object)("Query translator: " + className));
        try {
            return (QueryTranslatorFactory)ReflectHelper.classForName(className).newInstance();
        }
        catch (Exception cnfe) {
            throw new HibernateException("could not instantiate QueryTranslatorFactory: " + className, cnfe);
        }
    }

    protected BatcherFactory createBatcherFactory(Properties properties, int batchSize) {
        String batcherClass = properties.getProperty("hibernate.jdbc.factory_class");
        if (batcherClass == null) {
            return batchSize == 0 ? new NonBatchingBatcherFactory() : new BatchingBatcherFactory();
        }
        log.info((Object)("Batcher factory: " + batcherClass));
        try {
            return (BatcherFactory)ReflectHelper.classForName(batcherClass).newInstance();
        }
        catch (Exception cnfe) {
            throw new HibernateException("could not instantiate BatcherFactory: " + batcherClass, cnfe);
        }
    }

    protected ConnectionProvider createConnectionProvider(Properties properties) {
        return ConnectionProviderFactory.newConnectionProvider(properties);
    }

    protected TransactionFactory createTransactionFactory(Properties properties) {
        return TransactionFactoryFactory.buildTransactionFactory(properties);
    }

    protected TransactionManagerLookup createTransactionManagerLookup(Properties properties) {
        return TransactionManagerLookupFactory.getTransactionManagerLookup(properties);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        DIALECTS.put("HSQL Database Engine", "org.hibernate.dialect.HSQLDialect");
        DIALECTS.put("DB2/NT", "org.hibernate.dialect.DB2Dialect");
        DIALECTS.put("MySQL", "org.hibernate.dialect.MySQLDialect");
        DIALECTS.put("Oracle", "org.hibernate.dialect.Oracle9Dialect");
        DIALECTS.put("PostgreSQL", "org.hibernate.dialect.PostgreSQLDialect");
        DIALECTS.put("Microsoft SQL Server Database", "org.hibernate.dialect.SQLServerDialect");
        DIALECTS.put("Sybase SQL Server", "org.hibernate.dialect.SybaseDialect");
    }
}

