/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.CacheMode;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.cache.CacheKey;
import org.hibernate.cache.entry.CollectionCacheEntry;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.CollectionEntry;
import org.hibernate.engine.CollectionKey;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;

public class CollectionLoadContext {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$engine$CollectionLoadContext == null ? (class$org$hibernate$engine$CollectionLoadContext = CollectionLoadContext.class$("org.hibernate.engine.CollectionLoadContext")) : class$org$hibernate$engine$CollectionLoadContext));
    private final Map loadingCollections = new HashMap(8);
    private final PersistenceContext context;
    static /* synthetic */ Class class$org$hibernate$engine$CollectionLoadContext;

    public CollectionLoadContext(PersistenceContext context) {
        this.context = context;
    }

    public PersistentCollection getLoadingCollection(CollectionPersister persister, Serializable key, Object resultSetId, EntityMode em) throws HibernateException {
        CollectionKey ckey = new CollectionKey(persister, key, em);
        LoadingCollectionEntry lce = this.getLoadingCollectionEntry(ckey);
        if (lce == null) {
            PersistentCollection pc = this.context.getCollection(ckey);
            if (pc != null) {
                CollectionEntry ce = this.context.getCollectionEntry(pc);
                if (ce.isInitialized()) {
                    log.trace((Object)"collection already initialized: ignoring");
                    return null;
                }
                log.trace((Object)"uninitialized collection: initializing");
            } else {
                boolean newlySavedEntity;
                Object entity = this.context.getCollectionOwner(key, persister);
                boolean bl = newlySavedEntity = entity != null && this.context.getEntry(entity).getStatus() != Status.LOADING && em != EntityMode.DOM4J;
                if (newlySavedEntity) {
                    log.trace((Object)"owning entity already loaded: ignoring");
                    return null;
                }
                log.trace((Object)"new collection: instantiating");
                pc = persister.getCollectionType().instantiate(this.context.getSession(), persister, key);
            }
            pc.beforeInitialize(persister);
            pc.beginRead();
            this.addLoadingCollectionEntry(ckey, pc, resultSetId);
            return pc;
        }
        if (lce.resultSetId == resultSetId) {
            log.trace((Object)"reading row");
            return lce.collection;
        }
        log.trace((Object)"collection is already being initialized: ignoring row");
        return null;
    }

    public PersistentCollection getLoadingCollection(CollectionPersister persister, Serializable id, EntityMode em) {
        LoadingCollectionEntry lce = this.getLoadingCollectionEntry(new CollectionKey(persister, id, em));
        if (lce != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("returning loading collection:" + MessageHelper.collectionInfoString(persister, id, this.context.getSession().getFactory())));
            }
            return lce.collection;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("creating collection wrapper:" + MessageHelper.collectionInfoString(persister, id, this.context.getSession().getFactory())));
        }
        return null;
    }

    private void addLoadingCollectionEntry(CollectionKey collectionKey, PersistentCollection collection, Object resultSetId) {
        this.loadingCollections.put(collectionKey, new LoadingCollectionEntry(collection, collectionKey.getKey(), resultSetId));
    }

    private LoadingCollectionEntry getLoadingCollectionEntry(CollectionKey collectionKey) {
        return (LoadingCollectionEntry)this.loadingCollections.get(collectionKey);
    }

    private void endLoadingCollection(LoadingCollectionEntry lce, CollectionPersister persister, EntityMode em) {
        boolean addToCache;
        CollectionEntry ce;
        boolean hasNoQueuedAdds = lce.collection.endRead();
        if (persister.getCollectionType().hasHolder(em)) {
            this.context.addCollectionHolder(lce.collection);
        }
        if ((ce = this.context.getCollectionEntry(lce.collection)) == null) {
            ce = this.context.addInitializedCollection(lce.collection, persister, lce.key, em);
        } else {
            ce.postInitialize(lce.collection);
        }
        SessionImplementor session = this.context.getSession();
        boolean bl = addToCache = hasNoQueuedAdds && persister.hasCache() && session.getCacheMode().isPutEnabled() && !ce.isDoremove();
        if (addToCache) {
            this.addCollectionToCache(lce, persister);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("collection fully initialized: " + MessageHelper.collectionInfoString(persister, lce.key, this.context.getSession().getFactory())));
        }
        if (session.getFactory().getStatistics().isStatisticsEnabled()) {
            session.getFactory().getStatisticsImplementor().loadCollection(persister.getRole());
        }
    }

    public void endLoadingCollections(CollectionPersister persister, Object resultSetId, SessionImplementor session) throws HibernateException {
        ArrayList<LoadingCollectionEntry> resultSetCollections = null;
        Iterator iter = this.loadingCollections.values().iterator();
        while (iter.hasNext()) {
            LoadingCollectionEntry lce = (LoadingCollectionEntry)iter.next();
            if (lce.resultSetId != resultSetId) continue;
            if (resultSetCollections == null) {
                resultSetCollections = new ArrayList<LoadingCollectionEntry>();
            }
            resultSetCollections.add(lce);
            if (lce.collection.getOwner() == null) {
                session.getPersistenceContext().addUnownedCollection(new CollectionKey(persister, lce.key, session.getEntityMode()), lce.collection);
            }
            iter.remove();
        }
        this.endLoadingCollections(persister, resultSetCollections, session.getEntityMode());
    }

    private void endLoadingCollections(CollectionPersister persister, List resultSetCollections, EntityMode em) throws HibernateException {
        int count;
        int n = count = resultSetCollections == null ? 0 : resultSetCollections.size();
        if (log.isDebugEnabled()) {
            log.debug((Object)(count + " collections were found in result set"));
        }
        for (int i = 0; i < count; ++i) {
            LoadingCollectionEntry lce = (LoadingCollectionEntry)resultSetCollections.get(i);
            this.endLoadingCollection(lce, persister, em);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(count + " collections initialized"));
        }
    }

    private void addCollectionToCache(LoadingCollectionEntry lce, CollectionPersister persister) {
        Object version;
        Comparator versionComparator;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Caching collection: " + MessageHelper.collectionInfoString(persister, lce.key, this.context.getSession().getFactory())));
        }
        SessionImplementor session = this.context.getSession();
        SessionFactoryImplementor factory = session.getFactory();
        if (!session.getEnabledFilters().isEmpty() && persister.isAffectedByEnabledFilters(session)) {
            log.debug((Object)"Refusing to add to cache due to enabled filters");
            return;
        }
        if (persister.isVersioned()) {
            versionComparator = persister.getOwnerEntityPersister().getVersionType().getComparator();
            version = this.context.getEntry(this.context.getCollectionOwner(lce.key, persister)).getVersion();
        } else {
            version = null;
            versionComparator = null;
        }
        CollectionCacheEntry entry = new CollectionCacheEntry(lce.collection, persister);
        boolean put = persister.getCache().put(new CacheKey(lce.key, persister.getKeyType(), persister.getRole(), session.getEntityMode()), persister.getCacheEntryStructure().structure(entry), session.getTimestamp(), version, versionComparator, factory.getSettings().isMinimalPutsEnabled() && session.getCacheMode() != CacheMode.REFRESH);
        if (put && factory.getStatistics().isStatisticsEnabled()) {
            factory.getStatisticsImplementor().secondLevelCachePut(persister.getCache().getRegionName());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class LoadingCollectionEntry {
        final PersistentCollection collection;
        final Serializable key;
        final Object resultSetId;

        LoadingCollectionEntry(PersistentCollection collection, Serializable key, Object resultSetId) {
            this.collection = collection;
            this.key = key;
            this.resultSetId = resultSetId;
        }
    }
}

