/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import org.hibernate.EntityMode;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.Type;

public class EntityUniqueKey {
    private final String uniqueKeyName;
    private final String entityName;
    private final Object key;
    private final Type keyType;
    private EntityMode entityMode;

    public EntityUniqueKey(String entityName, String uniqueKeyName, Object key, Type keyType, EntityMode entityMode) {
        this.uniqueKeyName = uniqueKeyName;
        this.entityName = entityName;
        this.key = key;
        this.keyType = keyType;
        this.entityMode = entityMode;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public Object getKey() {
        return this.key;
    }

    public String getUniqueKeyName() {
        return this.uniqueKeyName;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.entityName.hashCode();
        result = 37 * result + this.uniqueKeyName.hashCode();
        result = 37 * result + this.keyType.getHashCode(this.key, this.entityMode);
        return result;
    }

    public boolean equals(Object other) {
        EntityUniqueKey that = (EntityUniqueKey)other;
        return that.entityName.equals(this.entityName) && that.uniqueKeyName.equals(this.uniqueKeyName) && this.keyType.isEqual(that.key, this.key, this.entityMode);
    }

    public String toString() {
        return "EntityUniqueKey" + MessageHelper.infoString(this.entityName, this.uniqueKeyName, this.key);
    }
}

