/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.QueryParameters;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.PropertyMapping;
import org.hibernate.util.StringHelper;

public class SubselectFetch {
    private final Set resultingEntityKeys = new HashSet();
    private final String queryString;
    private final String alias;
    private final Loadable loadable;
    private final QueryParameters queryParameters;

    public SubselectFetch(String alias, Loadable loadable, QueryParameters queryParameters, EntityKey[] resultingEntityKeys) {
        this.resultingEntityKeys.addAll(Arrays.asList(resultingEntityKeys));
        this.queryParameters = queryParameters;
        this.loadable = loadable;
        this.alias = alias;
        String queryString = queryParameters.getFilteredSQL();
        int fromIndex = queryString.indexOf(" from ");
        int orderByIndex = queryString.lastIndexOf("order by");
        this.queryString = orderByIndex > 0 ? queryString.substring(fromIndex, orderByIndex) : queryString.substring(fromIndex);
    }

    public QueryParameters getQueryParameters() {
        return this.queryParameters;
    }

    public Set getResult() {
        return this.resultingEntityKeys;
    }

    public String toSubselectString(String ukname) {
        String[] joinColumns = ukname == null ? StringHelper.qualify(this.alias, this.loadable.getIdentifierColumnNames()) : ((PropertyMapping)((Object)this.loadable)).toColumns(this.alias, ukname);
        return "select " + StringHelper.join(", ", joinColumns) + this.queryString;
    }

    public String toString() {
        return "SubselectFetch(" + this.queryString + ')';
    }
}

