/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast;

import antlr.collections.AST;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.QueryException;
import org.hibernate.engine.JoinSequence;
import org.hibernate.hql.ast.ASTUtil;
import org.hibernate.hql.ast.DisplayableNode;
import org.hibernate.hql.ast.FromClause;
import org.hibernate.hql.ast.FromElementType;
import org.hibernate.hql.ast.HqlSqlWalkerNode;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.PropertyMapping;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.util.StringHelper;

public class FromElement
extends HqlSqlWalkerNode
implements DisplayableNode {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$hql$ast$FromElement == null ? (class$org$hibernate$hql$ast$FromElement = FromElement.class$("org.hibernate.hql.ast.FromElement")) : class$org$hibernate$hql$ast$FromElement));
    private String className;
    private String classAlias;
    private String tableAlias;
    private String collectionTableAlias;
    private FromClause fromClause;
    private String selectFragment;
    private boolean includeSubclasses = true;
    private boolean collectionJoin = false;
    private FromElement origin;
    private String[] columns;
    private String role;
    private boolean fetch;
    private boolean isAllPropertyFetch;
    private boolean filter = false;
    private int sequence = -1;
    private boolean useFromFragment = false;
    private boolean initialized = false;
    private FromElementType elementType;
    private boolean useWhereFragment = true;
    private List destinations = new LinkedList();
    private boolean manyToMany = false;
    static /* synthetic */ Class class$org$hibernate$hql$ast$FromElement;

    void initializeCollection(FromClause fromClause, String classAlias, String tableAlias) {
        this.doInitialize(fromClause, tableAlias, null, classAlias, null, null);
        this.initialized = true;
    }

    private void doInitialize(FromClause fromClause, String tableAlias, String className, String classAlias, EntityPersister persister, EntityType type) {
        if (this.initialized) {
            throw new IllegalStateException("Already initialized!!");
        }
        this.fromClause = fromClause;
        this.tableAlias = tableAlias;
        this.className = className;
        this.classAlias = classAlias;
        this.elementType = new FromElementType(this, persister, type);
        fromClause.registerFromElement(this);
        if (log.isDebugEnabled()) {
            log.debug((Object)(fromClause + " :  " + className + " (" + (classAlias == null ? "no alias" : classAlias) + ") -> " + tableAlias));
        }
    }

    void initializeEntity(FromClause fromClause, String className, EntityPersister persister, EntityType type, String classAlias, String tableAlias) {
        this.doInitialize(fromClause, tableAlias, className, classAlias, persister, type);
        this.sequence = fromClause.nextFromElementCounter();
        this.initialized = true;
    }

    public EntityPersister getEntityPersister() {
        return this.elementType.getEntityPersister();
    }

    public Type getDataType() {
        return this.elementType.getDataType();
    }

    public Type getSelectType() {
        return this.elementType.getSelectType();
    }

    public Queryable getQueryable() {
        return this.elementType.getQueryable();
    }

    public String getClassName() {
        return this.className;
    }

    public String getClassAlias() {
        return this.classAlias;
    }

    private String getTableName() {
        Queryable queryable = this.getQueryable();
        return queryable != null ? queryable.getTableName() : "{none}";
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    String renderScalarIdentifierSelect(int i) {
        return this.elementType.renderScalarIdentifierSelect(i);
    }

    void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("FromElement has not been initialized!");
        }
    }

    String renderIdentifierSelect(int size, int k) {
        return this.elementType.renderIdentifierSelect(size, k);
    }

    String renderPropertySelect(int size, int k) {
        return this.elementType.renderPropertySelect(size, k, this.isAllPropertyFetch);
    }

    public FromClause getFromClause() {
        return this.fromClause;
    }

    boolean isImplied() {
        return false;
    }

    public String getDisplayText() {
        StringBuffer buf = new StringBuffer();
        buf.append("FromElement{");
        this.appendDisplayText(buf);
        buf.append("}");
        return buf.toString();
    }

    protected void appendDisplayText(StringBuffer buf) {
        buf.append(this.isImplied() ? (this.isImpliedInFromClause() ? "implied in FROM clause" : "implied") : "explicit");
        buf.append(",").append(this.isCollectionJoin() ? "collection join" : "not a collection join");
        buf.append(",").append(this.fetch ? "fetch join" : "not a fetch join");
        buf.append(",").append(this.isAllPropertyFetch ? "fetch all properties" : "fetch non-lazy properties");
        buf.append(",classAlias=").append(this.getClassAlias());
        buf.append(",role=").append(this.role);
        buf.append(",tableName=").append(this.getTableName());
        buf.append(",tableAlias=").append(this.getTableAlias());
        buf.append(",colums={");
        if (this.columns != null) {
            for (int i = 0; i < this.columns.length; ++i) {
                buf.append(this.columns[i]);
                if (i >= this.columns.length) continue;
                buf.append(" ");
            }
        }
        buf.append(",className=").append(this.className);
        buf.append("}");
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public void setJoinSequence(JoinSequence joinSequence) {
        this.elementType.setJoinSequence(joinSequence);
    }

    public JoinSequence getJoinSequence() {
        return this.elementType.getJoinSequence();
    }

    public String renderCollectionSelectFragment() {
        return this.selectFragment;
    }

    public void setSelectFragment(String selectFragment) {
        this.selectFragment = selectFragment;
    }

    public void setIncludeSubclasses(boolean includeSubclasses) {
        this.includeSubclasses = includeSubclasses;
    }

    public boolean isIncludeSubclasses() {
        return this.includeSubclasses;
    }

    public String getIdentityColumn() {
        this.checkInitialized();
        String table = this.getTableAlias();
        if (table == null) {
            throw new IllegalStateException("No table alias for node " + this);
        }
        String[] cols = this.getPropertyMapping("id").toColumns(table, "id");
        String result = StringHelper.join(", ", cols);
        return cols.length == 1 ? result : "(" + result + ")";
    }

    public void setCollectionJoin(boolean collectionJoin) {
        this.collectionJoin = collectionJoin;
    }

    public boolean isCollectionJoin() {
        return this.collectionJoin;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setQueryableCollection(QueryableCollection queryableCollection) {
        this.elementType.setQueryableCollection(queryableCollection);
    }

    public QueryableCollection getQueryableCollection() {
        return this.elementType.getQueryableCollection();
    }

    public void setColumns(String[] columns) {
        this.columns = columns;
    }

    public void setOrigin(FromElement origin, boolean manyToMany) {
        this.origin = origin;
        this.manyToMany = manyToMany;
        origin.addDestination(this);
        if (origin.getFromClause() == this.getFromClause()) {
            if (manyToMany) {
                ASTUtil.appendSibling((AST)origin, (AST)this);
            } else if (!this.getWalker().isInFrom() && !this.getWalker().isInSelect()) {
                this.getFromClause().addChild((AST)this);
            } else {
                origin.addChild((AST)this);
            }
        } else if (!this.getWalker().isInFrom()) {
            this.getFromClause().addChild((AST)this);
        }
    }

    boolean isManyToMany() {
        return this.manyToMany;
    }

    private void addDestination(FromElement fromElement) {
        this.destinations.add(fromElement);
    }

    List getDestinations() {
        return this.destinations;
    }

    public FromElement getOrigin() {
        return this.origin;
    }

    public Type getPropertyType(String propertyName, String propertyPath) {
        return this.elementType.getPropertyType(propertyName, propertyPath);
    }

    String[] toColumns(String tableAlias, String path, boolean inSelect) {
        return this.elementType.toColumns(tableAlias, path, inSelect);
    }

    PropertyMapping getPropertyMapping(String propertyName) {
        return this.elementType.getPropertyMapping(propertyName);
    }

    public void setFetch(boolean fetch) {
        this.fetch = fetch;
        if (fetch && this.getWalker().isShallowQuery()) {
            throw new QueryException("fetch may not be used with scroll() or iterate()");
        }
    }

    public boolean isFetch() {
        return this.fetch;
    }

    public int getSequence() {
        return this.sequence;
    }

    void setFilter(boolean b) {
        this.filter = b;
    }

    boolean isFilter() {
        return this.filter;
    }

    boolean useFromFragment() {
        this.checkInitialized();
        return !this.isImplied() || this.useFromFragment;
    }

    void setUseFromFragment(boolean useFromFragment) {
        this.useFromFragment = useFromFragment;
    }

    boolean useWhereFragment() {
        return this.useWhereFragment;
    }

    void setUseWhereFragment(boolean b) {
        this.useWhereFragment = b;
    }

    public void setCollectionTableAlias(String collectionTableAlias) {
        this.collectionTableAlias = collectionTableAlias;
    }

    public String getCollectionTableAlias() {
        return this.collectionTableAlias;
    }

    public boolean isCollectionOfValuesOrComponents() {
        return this.elementType.isCollectionOfValuesOrComponents();
    }

    public boolean isEntity() {
        return this.elementType.isEntity();
    }

    void setImpliedInFromClause(boolean flag) {
        throw new UnsupportedOperationException("Explicit FROM elements can't be implied in the FROM clause!");
    }

    boolean isImpliedInFromClause() {
        return false;
    }

    public void setInProjectionList(boolean inProjectionList) {
    }

    boolean inProjectionList() {
        return !this.isImplied() && this.isFromOrJoinFragment();
    }

    boolean isFromOrJoinFragment() {
        return this.getType() == 121 || this.getType() == 123;
    }

    public boolean isAllPropertyFetch() {
        return this.isAllPropertyFetch;
    }

    public void setAllPropertyFetch(boolean fetch) {
        this.isAllPropertyFetch = fetch;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

