/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.QueryException;
import org.hibernate.SQLQuery;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.engine.NamedSQLQueryDefinition;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.impl.AbstractQueryImpl;
import org.hibernate.loader.custom.SQLCustomQuery;
import org.hibernate.loader.custom.SQLQueryJoinReturn;
import org.hibernate.loader.custom.SQLQueryReturn;
import org.hibernate.loader.custom.SQLQueryRootReturn;
import org.hibernate.loader.custom.SQLQueryScalarReturn;
import org.hibernate.type.Type;
import org.hibernate.util.CollectionHelper;

public class SQLQueryImpl
extends AbstractQueryImpl
implements SQLQuery {
    private final List queryReturns;
    private final List scalarQueryReturns;
    private final Collection querySpaces;
    private final boolean callable;
    private static final SQLQueryReturn[] NO_SQL_RETURNS = new SQLQueryReturn[0];
    private static final SQLQueryScalarReturn[] NO_SQL_SCALAR_RETURNS = new SQLQueryScalarReturn[0];

    SQLQueryImpl(NamedSQLQueryDefinition queryDef, SessionImplementor session) {
        this(queryDef.getQueryString(), Arrays.asList(queryDef.getQueryReturns()), Arrays.asList(queryDef.getScalarQueryReturns()), queryDef.getQuerySpaces(), queryDef.getFlushMode(), queryDef.isCallable(), session);
    }

    SQLQueryImpl(String sql, List queryReturns, List scalarQueryReturns, Collection querySpaces, FlushMode flushMode, boolean callable, SessionImplementor session) {
        super(sql, flushMode, session);
        this.queryReturns = queryReturns;
        this.scalarQueryReturns = scalarQueryReturns;
        this.querySpaces = querySpaces;
        this.callable = callable;
    }

    SQLQueryImpl(String sql, String[] returnAliases, Class[] returnClasses, LockMode[] lockModes, SessionImplementor session, Collection querySpaces, FlushMode flushMode) {
        super(sql, flushMode, session);
        this.scalarQueryReturns = null;
        this.queryReturns = new ArrayList(returnAliases.length);
        for (int i = 0; i < returnAliases.length; ++i) {
            SQLQueryRootReturn ret = new SQLQueryRootReturn(returnAliases[i], returnClasses[i].getName(), lockModes == null ? LockMode.NONE : lockModes[i]);
            this.queryReturns.add(ret);
        }
        this.querySpaces = querySpaces;
        this.callable = false;
    }

    SQLQueryImpl(String sql, String[] returnAliases, Class[] returnClasses, SessionImplementor session) {
        this(sql, returnAliases, returnClasses, null, session, null, null);
    }

    SQLQueryImpl(String sql, SessionImplementor session) {
        super(sql, null, session);
        this.queryReturns = new ArrayList();
        this.scalarQueryReturns = new ArrayList();
        this.querySpaces = null;
        this.callable = false;
    }

    private SQLQueryReturn[] getQueryReturns() {
        return this.queryReturns.toArray(NO_SQL_RETURNS);
    }

    private SQLQueryScalarReturn[] getQueryScalarReturns() {
        return this.scalarQueryReturns == null ? null : this.scalarQueryReturns.toArray(NO_SQL_SCALAR_RETURNS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List list() throws HibernateException {
        this.verifyParameters();
        Map namedParams = this.getNamedParams();
        this.before();
        SQLCustomQuery cq = new SQLCustomQuery(this.getQueryReturns(), this.getQueryScalarReturns(), this.bindParameterLists(namedParams), this.querySpaces, this.getSession().getFactory());
        try {
            List list = this.getSession().listCustomQuery(cq, this.getQueryParameters(namedParams));
            return list;
        }
        finally {
            this.after();
        }
    }

    public QueryParameters getQueryParameters(Map namedParams) {
        QueryParameters qp = super.getQueryParameters(namedParams);
        qp.setCallable(this.callable);
        return qp;
    }

    protected void verifyParameters() {
        this.verifyParameters(this.callable);
        if ((this.queryReturns == null || this.queryReturns.isEmpty()) && (this.scalarQueryReturns == null || this.scalarQueryReturns.isEmpty())) {
            throw new QueryException("addEntity() or addScalar() must be called on a sql query before executing the query.", this.getQueryString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScrollableResults scroll(ScrollMode scrollMode) throws HibernateException {
        this.verifyParameters();
        Map namedParams = this.getNamedParams();
        this.before();
        SQLCustomQuery cq = new SQLCustomQuery(this.getQueryReturns(), this.getQueryScalarReturns(), this.bindParameterLists(namedParams), this.querySpaces, this.getSession().getFactory());
        QueryParameters qp = this.getQueryParameters(namedParams);
        qp.setScrollMode(scrollMode);
        try {
            ScrollableResults scrollableResults = this.getSession().scrollCustomQuery(cq, qp);
            return scrollableResults;
        }
        finally {
            this.after();
        }
    }

    public ScrollableResults scroll() throws HibernateException {
        return this.scroll(ScrollMode.SCROLL_INSENSITIVE);
    }

    public Iterator iterate() throws HibernateException {
        throw new UnsupportedOperationException("SQL queries do not currently support iteration");
    }

    public Type[] getReturnTypes() throws HibernateException {
        throw new UnsupportedOperationException("not yet implemented for SQL queries");
    }

    public Query setLockMode(String alias, LockMode lockMode) {
        throw new UnsupportedOperationException("cannot set the lock mode for a native SQL query");
    }

    protected Map getLockModes() {
        return CollectionHelper.EMPTY_MAP;
    }

    public SQLQuery addScalar(String columnAlias, Type type) {
        this.scalarQueryReturns.add(new SQLQueryScalarReturn(columnAlias, type));
        return this;
    }

    public SQLQuery addJoin(String alias, String path) {
        return this.addJoin(alias, path, LockMode.READ);
    }

    public SQLQuery addEntity(String alias, String entityName) {
        return this.addEntity(alias, entityName, LockMode.READ);
    }

    public SQLQuery addEntity(String alias, Class entityClass) {
        return this.addEntity(alias, entityClass.getName());
    }

    public SQLQuery addJoin(String alias, String path, LockMode lockMode) {
        int loc = path.indexOf(46);
        if (loc < 0) {
            throw new QueryException("not a property path: " + path);
        }
        String ownerAlias = path.substring(0, loc);
        String role = path.substring(loc + 1);
        this.queryReturns.add(new SQLQueryJoinReturn(alias, ownerAlias, role, CollectionHelper.EMPTY_MAP, lockMode));
        return this;
    }

    public SQLQuery addEntity(String alias, String entityName, LockMode lockMode) {
        this.queryReturns.add(new SQLQueryRootReturn(alias, entityName, lockMode));
        return this;
    }

    public SQLQuery addEntity(String alias, Class entityClass, LockMode lockMode) {
        return this.addEntity(alias, entityClass.getName(), lockMode);
    }
}

