/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader;

import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.loader.EntityAliases;
import org.hibernate.loader.GeneratedEntityAliases;
import org.hibernate.loader.Loader;
import org.hibernate.persister.entity.Loadable;

public abstract class BasicLoader
extends Loader {
    protected static final String[] NO_SUFFIX = new String[]{""};
    private EntityAliases[] descriptors;

    public BasicLoader(SessionFactoryImplementor factory) {
        super(factory);
    }

    protected EntityAliases[] getEntityAliases() {
        return this.descriptors;
    }

    protected abstract String[] getSuffixes();

    protected void postInstantiate() {
        Loadable[] persisters = this.getEntityPersisters();
        String[] suffixes = this.getSuffixes();
        this.descriptors = new EntityAliases[persisters.length];
        for (int i = 0; i < this.descriptors.length; ++i) {
            this.descriptors[i] = new GeneratedEntityAliases(persisters[i], suffixes[i]);
        }
    }

    public static String[] generateSuffixes(int length) {
        if (length == 0) {
            return NO_SUFFIX;
        }
        String[] suffixes = new String[length];
        for (int i = 0; i < length; ++i) {
            suffixes[i] = Integer.toString(i) + '_';
        }
        return suffixes;
    }
}

