/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader;

import java.util.Map;
import org.hibernate.loader.EntityAliases;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.SQLLoadable;

public class SQLGeneratedEntityAliases
implements EntityAliases {
    private String[] suffixedKeyColumns;
    private final String[] suffixedVersionColumn;
    private final String[][] suffixedPropertyColumns;
    private final String suffixedDiscriminatorColumn;
    private final String suffix;
    private final String rowIdAlias;
    private Map propertyResults;

    public SQLGeneratedEntityAliases(Map propertyResults, SQLLoadable persister, String suffix) {
        this.suffix = suffix;
        this.propertyResults = propertyResults;
        this.suffixedKeyColumns = this.get(persister.getIdentifierPropertyName(), (String[])null);
        if (this.suffixedKeyColumns == null) {
            this.suffixedKeyColumns = this.get("id", persister.getIdentifierAliases(suffix));
        }
        SQLGeneratedEntityAliases.intern(this.suffixedKeyColumns);
        this.suffixedPropertyColumns = this.getSuffixedPropertyAliases(persister);
        this.suffixedDiscriminatorColumn = this.get("class", persister.getDiscriminatorAlias(suffix));
        this.suffixedVersionColumn = persister.isVersioned() ? this.suffixedPropertyColumns[persister.getVersionProperty()] : null;
        this.rowIdAlias = "rowid_" + suffix;
    }

    private String[] get(String propertyPath, String[] aliases) {
        String[] columns = (String[])this.propertyResults.get(propertyPath);
        if (columns == null) {
            return aliases;
        }
        return columns;
    }

    private String get(String propertyPath, String alias) {
        String[] columns = (String[])this.propertyResults.get(propertyPath);
        if (columns == null) {
            return alias;
        }
        return columns[0];
    }

    public String[][] getSuffixedPropertyAliases(Loadable persister) {
        int size = persister.getPropertyNames().length;
        String[][] suffixedPropertyAliases = new String[size][];
        for (int j = 0; j < size; ++j) {
            suffixedPropertyAliases[j] = this.get(persister.getPropertyNames()[j], persister.getPropertyAliases(this.suffix, j));
            SQLGeneratedEntityAliases.intern(suffixedPropertyAliases[j]);
        }
        return suffixedPropertyAliases;
    }

    public String[] getSuffixedVersionAliases() {
        return this.suffixedVersionColumn;
    }

    public String[][] getSuffixedPropertyAliases() {
        return this.suffixedPropertyColumns;
    }

    public String getSuffixedDiscriminatorAlias() {
        return this.suffixedDiscriminatorColumn;
    }

    public String[] getSuffixedKeyAliases() {
        return this.suffixedKeyColumns;
    }

    public String getRowIdAlias() {
        return this.rowIdAlias;
    }

    private static void intern(String[] strings) {
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = strings[i].intern();
        }
    }
}

