/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transaction;

import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.jdbc.JDBCContext;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.util.JTAHelper;

public class CMTTransaction
implements Transaction {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$transaction$CMTTransaction == null ? (class$org$hibernate$transaction$CMTTransaction = CMTTransaction.class$("org.hibernate.transaction.CMTTransaction")) : class$org$hibernate$transaction$CMTTransaction));
    private final JDBCContext jdbcContext;
    private final TransactionFactory.Context transactionContext;
    private boolean begun;
    private javax.transaction.Transaction transaction;
    static /* synthetic */ Class class$org$hibernate$transaction$CMTTransaction;

    public CMTTransaction(JDBCContext jdbcContext, TransactionFactory.Context transactionContext) {
        this.jdbcContext = jdbcContext;
        this.transactionContext = transactionContext;
    }

    public void begin() throws HibernateException {
        log.debug((Object)"begin");
        boolean synchronization = this.jdbcContext.registerSynchronizationIfPossible();
        if (!synchronization) {
            throw new TransactionException("Could not register synchronization for container transaction");
        }
        this.begun = true;
    }

    public void commit() throws HibernateException {
        boolean flush;
        if (!this.begun) {
            throw new TransactionException("Transaction not successfully started");
        }
        log.debug((Object)"commit");
        boolean bl = flush = !this.transactionContext.isFlushModeNever() && !this.transactionContext.isFlushBeforeCompletionEnabled();
        if (flush) {
            this.transactionContext.managedFlush();
        }
    }

    public void rollback() throws HibernateException {
        if (!this.begun) {
            throw new TransactionException("Transaction not successfully started");
        }
        log.debug((Object)"rollback");
        try {
            this.transaction.setRollbackOnly();
        }
        catch (SystemException se) {
            log.error((Object)"Could not set transaction to rollback only", (Throwable)se);
            throw new TransactionException("Could not set transaction to rollback only", (Exception)((Object)se));
        }
    }

    public boolean isActive() throws TransactionException {
        int status;
        if (!this.begun) {
            return false;
        }
        try {
            status = this.transaction.getStatus();
        }
        catch (SystemException se) {
            log.error((Object)"Could not determine transaction status", (Throwable)se);
            throw new TransactionException("Could not determine transaction status: ", (Exception)((Object)se));
        }
        if (status == 5) {
            throw new TransactionException("Could not determine transaction status");
        }
        return status == 0;
    }

    public boolean wasRolledBack() throws TransactionException {
        int status;
        if (!this.begun) {
            return false;
        }
        try {
            status = this.transaction.getStatus();
        }
        catch (SystemException se) {
            log.error((Object)"Could not determine transaction status", (Throwable)se);
            throw new TransactionException("Could not determine transaction status", (Exception)((Object)se));
        }
        if (status == 5) {
            throw new TransactionException("Could not determine transaction status");
        }
        return JTAHelper.isRollback(status);
    }

    public boolean wasCommitted() throws TransactionException {
        int status;
        if (!this.begun) {
            return false;
        }
        try {
            status = this.transaction.getStatus();
        }
        catch (SystemException se) {
            log.error((Object)"Could not determine transaction status", (Throwable)se);
            throw new TransactionException("Could not determine transaction status: ", (Exception)((Object)se));
        }
        if (status == 5) {
            throw new TransactionException("Could not determine transaction status");
        }
        return status == 3;
    }

    public void registerSynchronization(Synchronization sync) throws HibernateException {
        if (this.transaction != null) {
            try {
                this.transaction.registerSynchronization(sync);
            }
            catch (Exception e) {
                throw new TransactionException("Could not register synchronization", e);
            }
        } else {
            throw new IllegalStateException("JTA TransactionManager not available");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

