/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.util.StringHelper;

public final class JDBCExceptionReporter {
    public static final Log log = LogFactory.getLog((Class)(class$org$hibernate$util$JDBCExceptionReporter == null ? (class$org$hibernate$util$JDBCExceptionReporter = JDBCExceptionReporter.class$("org.hibernate.util.JDBCExceptionReporter")) : class$org$hibernate$util$JDBCExceptionReporter));
    public static final String DEFAULT_EXCEPTION_MSG = "SQL Exception";
    public static final String DEFAULT_WARNING_MSG = "SQL Warning";
    static /* synthetic */ Class class$org$hibernate$util$JDBCExceptionReporter;

    private JDBCExceptionReporter() {
    }

    public static void logAndClearWarnings(Connection connection) {
        if (log.isWarnEnabled()) {
            try {
                JDBCExceptionReporter.logWarnings(connection.getWarnings());
                connection.clearWarnings();
            }
            catch (SQLException sqle) {
                log.debug((Object)"could not log warnings", (Throwable)sqle);
            }
        }
    }

    public static void logWarnings(SQLWarning warning) {
        JDBCExceptionReporter.logWarnings(warning, null);
    }

    public static void logWarnings(SQLWarning warning, String message) {
        if (log.isWarnEnabled()) {
            if (log.isDebugEnabled() && warning != null) {
                message = StringHelper.isNotEmpty(message) ? message : DEFAULT_WARNING_MSG;
                log.debug((Object)message, (Throwable)warning);
            }
            while (warning != null) {
                StringBuffer buf = new StringBuffer(30).append("SQL Warning: ").append(warning.getErrorCode()).append(", SQLState: ").append(warning.getSQLState());
                log.warn((Object)buf.toString());
                log.warn((Object)warning.getMessage());
                warning = warning.getNextWarning();
            }
        }
    }

    public static void logExceptions(SQLException ex) {
        JDBCExceptionReporter.logExceptions(ex, null);
    }

    public static void logExceptions(SQLException ex, String message) {
        if (log.isErrorEnabled()) {
            if (log.isDebugEnabled()) {
                message = StringHelper.isNotEmpty(message) ? message : DEFAULT_EXCEPTION_MSG;
                log.debug((Object)message, (Throwable)ex);
            }
            while (ex != null) {
                StringBuffer buf = new StringBuffer(30).append("SQL Error: ").append(ex.getErrorCode()).append(", SQLState: ").append(ex.getSQLState());
                log.warn((Object)buf.toString());
                log.error((Object)ex.getMessage());
                ex = ex.getNextException();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

