/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.gvt;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.event.AWTEventDispatcher;
import org.apache.batik.gvt.renderer.ConcreteImageRendererFactory;
import org.apache.batik.gvt.renderer.ImageRenderer;
import org.apache.batik.gvt.renderer.ImageRendererFactory;
import org.apache.batik.gvt.text.Mark;
import org.apache.batik.swing.gvt.GVTTreeRenderer;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.GVTTreeRendererListener;
import org.apache.batik.swing.gvt.Interactor;
import org.apache.batik.swing.gvt.JGVTComponent;
import org.apache.batik.swing.gvt.Overlay;
import org.apache.batik.swing.gvt.TextSelectionManager;

public class JGVTComponent
extends JComponent {
    protected Listener listener;
    protected GVTTreeRenderer gvtTreeRenderer;
    protected GraphicsNode gvtRoot;
    protected ImageRendererFactory rendererFactory = new ConcreteImageRendererFactory();
    protected ImageRenderer renderer;
    protected List gvtTreeRendererListeners = Collections.synchronizedList(new LinkedList());
    protected boolean needRender;
    protected boolean progressivePaint;
    protected Thread progressivePaintThread;
    protected BufferedImage image;
    protected AffineTransform initialTransform;
    protected AffineTransform renderingTransform;
    protected AffineTransform paintingTransform;
    protected List interactors = new LinkedList();
    protected Interactor interactor;
    protected List overlays = new LinkedList();
    protected AWTEventDispatcher eventDispatcher;
    protected TextSelectionManager textSelectionManager;
    protected boolean doubleBufferedRendering;
    protected boolean eventsEnabled;
    protected boolean selectableText;
    protected boolean suspendInteractions;
    protected boolean disableInteractions;

    public JGVTComponent() {
        this(false, false);
    }

    public JGVTComponent(boolean eventsEnabled, boolean selectableText) {
        this.setBackground(Color.white);
        this.eventsEnabled = eventsEnabled;
        this.selectableText = selectableText;
        this.listener = this.createListener();
        this.addKeyListener(this.listener);
        this.addMouseListener(this.listener);
        this.addMouseMotionListener(this.listener);
        this.addGVTTreeRendererListener(this.listener);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                JGVTComponent.this.updateRenderingTransform();
                JGVTComponent.this.scheduleGVTRendering();
            }
        });
    }

    public List getInteractors() {
        return this.interactors;
    }

    public List getOverlays() {
        return this.overlays;
    }

    public BufferedImage getOffScreen() {
        return this.image;
    }

    public void resetRenderingTransform() {
        this.setRenderingTransform(this.initialTransform);
    }

    public void stopProcessing() {
        if (this.gvtTreeRenderer != null) {
            this.needRender = false;
            this.gvtTreeRenderer.interrupt();
            this.interruptProgressivePaintThread();
        }
    }

    public GraphicsNode getGraphicsNode() {
        return this.gvtRoot;
    }

    public void setGraphicsNode(GraphicsNode gn) {
        this.setGraphicsNode(gn, true);
    }

    protected void setGraphicsNode(GraphicsNode gn, boolean createDispatcher) {
        this.gvtRoot = gn;
        if (gn != null && createDispatcher) {
            this.initializeEventHandling();
        }
        if (this.eventDispatcher != null) {
            this.eventDispatcher.setRootNode(gn);
        }
        this.computeRenderingTransform();
    }

    protected void initializeEventHandling() {
        if (this.eventsEnabled) {
            this.eventDispatcher = new AWTEventDispatcher();
            if (this.selectableText) {
                this.textSelectionManager = new TextSelectionManager(this, this.eventDispatcher);
            }
        }
    }

    public void setSelectionOverlayColor(Color color) {
        if (this.textSelectionManager != null) {
            this.textSelectionManager.setSelectionOverlayColor(color);
        }
    }

    public Color getSelectionOverlayColor() {
        if (this.textSelectionManager != null) {
            return this.textSelectionManager.getSelectionOverlayColor();
        }
        return null;
    }

    public void setSelectionOverlayStrokeColor(Color color) {
        if (this.textSelectionManager != null) {
            this.textSelectionManager.setSelectionOverlayStrokeColor(color);
        }
    }

    public Color getSelectionOverlayStrokeColor() {
        if (this.textSelectionManager != null) {
            return this.textSelectionManager.getSelectionOverlayStrokeColor();
        }
        return null;
    }

    public void setSelectionOverlayXORMode(boolean state) {
        if (this.textSelectionManager != null) {
            this.textSelectionManager.setSelectionOverlayXORMode(state);
        }
    }

    public boolean isSelectionOverlayXORMode() {
        if (this.textSelectionManager != null) {
            return this.textSelectionManager.isSelectionOverlayXORMode();
        }
        return false;
    }

    public void select(Mark start, Mark end) {
        if (this.textSelectionManager != null) {
            this.textSelectionManager.setSelection(start, end);
        }
    }

    public void deselectAll() {
        if (this.textSelectionManager != null) {
            this.textSelectionManager.clearSelection();
        }
    }

    public void setProgressivePaint(boolean b) {
        if (this.progressivePaint != b) {
            this.progressivePaint = b;
            this.interruptProgressivePaintThread();
        }
    }

    public boolean getProgressivePaint() {
        return this.progressivePaint;
    }

    public void immediateRepaint() {
        if (EventQueue.isDispatchThread()) {
            Dimension dim = this.getSize();
            if (this.doubleBufferedRendering) {
                this.repaint(0, 0, dim.width, dim.height);
            } else {
                this.paintImmediately(0, 0, dim.width, dim.height);
            }
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        Dimension dim = JGVTComponent.this.getSize();
                        if (JGVTComponent.this.doubleBufferedRendering) {
                            JGVTComponent.this.repaint(0, 0, dim.width, dim.height);
                        } else {
                            JGVTComponent.this.paintImmediately(0, 0, dim.width, dim.height);
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        Dimension d = this.getSize();
        g2d.setComposite(AlphaComposite.SrcOver);
        g2d.setPaint(this.getBackground());
        g2d.fillRect(0, 0, d.width, d.height);
        if (this.image != null) {
            if (this.paintingTransform != null) {
                g2d.transform(this.paintingTransform);
            }
            g2d.drawRenderedImage(this.image, null);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            Iterator it = this.overlays.iterator();
            while (it.hasNext()) {
                ((Overlay)it.next()).paint(g);
            }
        }
    }

    public void setPaintingTransform(AffineTransform at) {
        this.paintingTransform = at;
        this.immediateRepaint();
    }

    public AffineTransform getPaintingTransform() {
        return this.paintingTransform;
    }

    public void setRenderingTransform(AffineTransform at) {
        this.renderingTransform = at;
        this.suspendInteractions = true;
        if (this.eventDispatcher != null) {
            try {
                this.eventDispatcher.setBaseTransform(this.renderingTransform.createInverse());
            }
            catch (NoninvertibleTransformException e) {
                this.handleException(e);
            }
        }
        this.scheduleGVTRendering();
    }

    public AffineTransform getInitialTransform() {
        return this.initialTransform;
    }

    public AffineTransform getRenderingTransform() {
        return this.renderingTransform;
    }

    public void setDoubleBufferedRendering(boolean b) {
        this.doubleBufferedRendering = b;
    }

    public boolean getDoubleBufferedRendering() {
        return this.doubleBufferedRendering;
    }

    public void addGVTTreeRendererListener(GVTTreeRendererListener l) {
        this.gvtTreeRendererListeners.add(l);
    }

    public void removeGVTTreeRendererListener(GVTTreeRendererListener l) {
        this.gvtTreeRendererListeners.remove(l);
    }

    public void flush() {
        this.renderer.flush();
    }

    public void flush(Rectangle r) {
        this.renderer.flush(r);
    }

    protected ImageRenderer createImageRenderer() {
        return this.rendererFactory.createStaticImageRenderer();
    }

    protected void renderGVTTree() {
        AffineTransform inv;
        Dimension d = this.getSize();
        if (this.gvtRoot == null || d.width <= 0 || d.height <= 0) {
            return;
        }
        if (this.renderer == null || this.renderer.getTree() != this.gvtRoot) {
            this.renderer = this.createImageRenderer();
            this.renderer.setTree(this.gvtRoot);
        }
        try {
            inv = this.renderingTransform.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            throw new InternalError(e.getMessage());
        }
        Shape s = inv.createTransformedShape(new Rectangle(0, 0, d.width, d.height));
        this.gvtTreeRenderer = new GVTTreeRenderer(this.renderer, this.renderingTransform, this.doubleBufferedRendering, s, d.width, d.height);
        this.gvtTreeRenderer.setPriority(1);
        Iterator it = this.gvtTreeRendererListeners.iterator();
        while (it.hasNext()) {
            this.gvtTreeRenderer.addGVTTreeRendererListener((GVTTreeRendererListener)it.next());
        }
        if (this.eventDispatcher != null) {
            this.eventDispatcher.setRootNode(null);
        }
        this.gvtTreeRenderer.start();
    }

    protected void computeRenderingTransform() {
        this.initialTransform = new AffineTransform();
        this.setRenderingTransform(this.initialTransform);
    }

    protected void updateRenderingTransform() {
    }

    protected void handleException(Exception e) {
    }

    protected void releaseRenderingReferences() {
        this.eventDispatcher = null;
        if (this.textSelectionManager != null) {
            this.overlays.remove(this.textSelectionManager.getSelectionOverlay());
            this.textSelectionManager = null;
        }
        this.renderer = null;
        this.gvtRoot = null;
    }

    protected void scheduleGVTRendering() {
        if (this.gvtTreeRenderer != null) {
            this.needRender = true;
            this.gvtTreeRenderer.interrupt();
        } else {
            this.renderGVTTree();
        }
    }

    private void interruptProgressivePaintThread() {
        if (this.progressivePaintThread != null) {
            this.progressivePaintThread.interrupt();
            this.progressivePaintThread = null;
        }
    }

    protected Listener createListener() {
        return new Listener();
    }

    protected class Listener
    implements GVTTreeRendererListener,
    KeyListener,
    MouseListener,
    MouseMotionListener {
        protected Listener() {
        }

        public void gvtRenderingPrepare(GVTTreeRendererEvent e) {
            JGVTComponent.this.suspendInteractions = true;
            if (!JGVTComponent.this.progressivePaint && !JGVTComponent.this.doubleBufferedRendering) {
                JGVTComponent.this.image = null;
                JGVTComponent.this.immediateRepaint();
            }
        }

        public void gvtRenderingStarted(GVTTreeRendererEvent e) {
            JGVTComponent.this.paintingTransform = null;
            if (JGVTComponent.this.progressivePaint && !JGVTComponent.this.doubleBufferedRendering) {
                JGVTComponent.this.image = e.getImage();
                JGVTComponent.this.progressivePaintThread = new Thread(this){
                    private final /* synthetic */ Listener this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        3 thisThread = this;
                        try {
                            while (!this.isInterrupted()) {
                                EventQueue.invokeLater(new Runnable(this, thisThread){
                                    private final /* synthetic */ Thread val$thisThread;
                                    private final /* synthetic */ 3 this$2;
                                    {
                                        this.this$2 = this$2;
                                        this.val$thisThread = val$thisThread;
                                    }

                                    public void run() {
                                        if (Listener.access$100((Listener)3.access$000(this.this$2)).progressivePaintThread == this.val$thisThread) {
                                            Dimension dim = Listener.access$100(3.access$000(this.this$2)).getSize();
                                            Listener.access$100(3.access$000(this.this$2)).repaint(0, 0, dim.width, dim.height);
                                        }
                                    }
                                });
                                Thread.sleep(200L);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }

                    static /* synthetic */ Listener access$000(3 x0) {
                        return x0.this$1;
                    }
                };
                JGVTComponent.this.progressivePaintThread.setPriority(2);
                JGVTComponent.this.progressivePaintThread.start();
            }
            if (!JGVTComponent.this.doubleBufferedRendering) {
                JGVTComponent.this.suspendInteractions = false;
            }
        }

        public void gvtRenderingCompleted(GVTTreeRendererEvent e) {
            JGVTComponent.this.interruptProgressivePaintThread();
            if (JGVTComponent.this.doubleBufferedRendering) {
                JGVTComponent.this.suspendInteractions = false;
            }
            JGVTComponent.this.gvtTreeRenderer = null;
            if (JGVTComponent.this.needRender) {
                JGVTComponent.this.renderGVTTree();
                JGVTComponent.this.needRender = false;
            } else {
                JGVTComponent.this.image = e.getImage();
                JGVTComponent.this.immediateRepaint();
            }
            if (JGVTComponent.this.eventDispatcher != null) {
                JGVTComponent.this.eventDispatcher.setRootNode(JGVTComponent.this.gvtRoot);
            }
        }

        public void gvtRenderingCancelled(GVTTreeRendererEvent e) {
            this.renderingStopped();
        }

        public void gvtRenderingFailed(GVTTreeRendererEvent e) {
            this.renderingStopped();
        }

        private void renderingStopped() {
            JGVTComponent.this.interruptProgressivePaintThread();
            if (JGVTComponent.this.doubleBufferedRendering) {
                JGVTComponent.this.suspendInteractions = false;
            }
            JGVTComponent.this.gvtTreeRenderer = null;
            if (JGVTComponent.this.needRender) {
                JGVTComponent.this.renderGVTTree();
                JGVTComponent.this.needRender = false;
            } else {
                JGVTComponent.this.immediateRepaint();
            }
        }

        public void keyTyped(KeyEvent e) {
            this.selectInteractor(e);
            if (JGVTComponent.this.interactor != null) {
                JGVTComponent.this.interactor.keyTyped(e);
                this.deselectInteractor();
            } else if (JGVTComponent.this.eventDispatcher != null) {
                this.dispatchKeyTyped(e);
            }
        }

        protected void dispatchKeyTyped(KeyEvent e) {
            JGVTComponent.this.eventDispatcher.keyTyped(e);
        }

        public void keyPressed(KeyEvent e) {
            this.selectInteractor(e);
            if (JGVTComponent.this.interactor != null) {
                JGVTComponent.this.interactor.keyPressed(e);
                this.deselectInteractor();
            } else if (JGVTComponent.this.eventDispatcher != null) {
                this.dispatchKeyPressed(e);
            }
        }

        protected void dispatchKeyPressed(KeyEvent e) {
            JGVTComponent.this.eventDispatcher.keyPressed(e);
        }

        public void keyReleased(KeyEvent e) {
            this.selectInteractor(e);
            if (JGVTComponent.this.interactor != null) {
                JGVTComponent.this.interactor.keyReleased(e);
                this.deselectInteractor();
            } else if (JGVTComponent.this.eventDispatcher != null) {
                this.dispatchKeyReleased(e);
            }
        }

        protected void dispatchKeyReleased(KeyEvent e) {
            JGVTComponent.this.eventDispatcher.keyReleased(e);
        }

        public void mouseClicked(MouseEvent e) {
            this.selectInteractor(e);
            if (JGVTComponent.this.interactor != null) {
                JGVTComponent.this.interactor.mouseClicked(e);
                this.deselectInteractor();
            } else if (JGVTComponent.this.eventDispatcher != null) {
                this.dispatchMouseClicked(e);
            }
        }

        protected void dispatchMouseClicked(MouseEvent e) {
            JGVTComponent.this.eventDispatcher.mouseClicked(e);
        }

        public void mousePressed(MouseEvent e) {
            this.selectInteractor(e);
            if (JGVTComponent.this.interactor != null) {
                JGVTComponent.this.interactor.mousePressed(e);
                this.deselectInteractor();
            } else if (JGVTComponent.this.eventDispatcher != null) {
                this.dispatchMousePressed(e);
            }
        }

        protected void dispatchMousePressed(MouseEvent e) {
            JGVTComponent.this.eventDispatcher.mousePressed(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.selectInteractor(e);
            if (JGVTComponent.this.interactor != null) {
                JGVTComponent.this.interactor.mouseReleased(e);
                this.deselectInteractor();
            } else if (JGVTComponent.this.eventDispatcher != null) {
                this.dispatchMouseReleased(e);
            }
        }

        protected void dispatchMouseReleased(MouseEvent e) {
            JGVTComponent.this.eventDispatcher.mouseReleased(e);
        }

        public void mouseEntered(MouseEvent e) {
            JGVTComponent.this.requestFocus();
            this.selectInteractor(e);
            if (JGVTComponent.this.interactor != null) {
                JGVTComponent.this.interactor.mouseEntered(e);
                this.deselectInteractor();
            } else if (JGVTComponent.this.eventDispatcher != null) {
                this.dispatchMouseEntered(e);
            }
        }

        protected void dispatchMouseEntered(MouseEvent e) {
            JGVTComponent.this.eventDispatcher.mouseEntered(e);
        }

        public void mouseExited(MouseEvent e) {
            this.selectInteractor(e);
            if (JGVTComponent.this.interactor != null) {
                JGVTComponent.this.interactor.mouseExited(e);
                this.deselectInteractor();
            } else if (JGVTComponent.this.eventDispatcher != null) {
                this.dispatchMouseExited(e);
            }
        }

        protected void dispatchMouseExited(MouseEvent e) {
            JGVTComponent.this.eventDispatcher.mouseExited(e);
        }

        public void mouseDragged(MouseEvent e) {
            this.selectInteractor(e);
            if (JGVTComponent.this.interactor != null) {
                JGVTComponent.this.interactor.mouseDragged(e);
                this.deselectInteractor();
            } else if (JGVTComponent.this.eventDispatcher != null) {
                this.dispatchMouseDragged(e);
            }
        }

        protected void dispatchMouseDragged(MouseEvent e) {
            JGVTComponent.this.eventDispatcher.mouseDragged(e);
        }

        public void mouseMoved(MouseEvent e) {
            this.selectInteractor(e);
            if (JGVTComponent.this.interactor != null) {
                JGVTComponent.this.interactor.mouseMoved(e);
                this.deselectInteractor();
            } else if (JGVTComponent.this.eventDispatcher != null) {
                this.dispatchMouseMoved(e);
            }
        }

        protected void dispatchMouseMoved(MouseEvent e) {
            JGVTComponent.this.eventDispatcher.mouseMoved(e);
        }

        protected void selectInteractor(InputEvent ie) {
            if (!JGVTComponent.this.disableInteractions && !JGVTComponent.this.suspendInteractions && JGVTComponent.this.interactor == null && JGVTComponent.this.gvtRoot != null) {
                Iterator it = JGVTComponent.this.interactors.iterator();
                while (it.hasNext()) {
                    Interactor i = (Interactor)it.next();
                    if (!i.startInteraction(ie)) continue;
                    JGVTComponent.this.interactor = i;
                    break;
                }
            }
        }

        protected void deselectInteractor() {
            if (JGVTComponent.this.interactor.endInteraction()) {
                JGVTComponent.this.interactor = null;
            }
        }

        static /* synthetic */ JGVTComponent access$100(Listener x0) {
            return x0.JGVTComponent.this;
        }
    }
}

