CREATE SEQUENCE seq_protocol;

CREATE TABLE protocol (
	id bigint DEFAULT nextval('seq_protocol') PRIMARY KEY,
	prot_date date, 
	table_name varchar(50),
	field_name varchar(50),
	before text,
	after text,
	changed_by int REFERENCES distributor,
	datatype varchar(20),
	identifier varchar(50)
);

CREATE SEQUENCE seq_accept_protocol;

CREATE TABLE accept_protocol (
	id bigint DEFAULT nextval('seq_accept_protocol') PRIMARY KEY,
	accept_date date, 
	accepted_by int,
	distr_id int,
	similar_users text
);

CREATE SEQUENCE seq_contact_type;

CREATE TABLE contact_type (
	id int DEFAULT nextval('seq_contact_type') PRIMARY KEY,
	descr varchar(50)
);

CREATE SEQUENCE seq_contact;
CREATE TABLE contact (
	distr_id int REFERENCES distributor,
	id bigint DEFAULT nextval('seq_contact') PRIMARY KEY,
	contact_date timestamp ,
	comment varchar (50),
	large_comment text,
	agent_id int REFERENCES distributor,
	contact_type_id int REFERENCES contact_type
);

CREATE TABLE options (
	trade_margin_customer decimal(18, 0),
	trade_margin_vip decimal(18, 0),
	trade_margin_distributor decimal(18, 0),
	customer_service decimal(10, 0)
);
