CREATE TABLE order_status_rights (
  role_id integer REFERENCES user_roles,
  order_status_id integer REFERENCES  order_status,
  change varchar(20),
  view varchar(20),
  storno varchar(20),
  nextproc varchar(20),
  PRIMARY KEY(role_id, order_status_id)
);

CREATE TABLE order_status_matrix (
  role_id integer REFERENCES user_roles,
  from_order_status integer REFERENCES order_status,
  to_order_status integer REFERENCES order_status,
  condition text,
  PRIMARY KEY(role_id, from_order_status, to_order_status)
);

CREATE TABLE general_rights (
  role_id integer PRIMARY KEY REFERENCES user_roles,
  article_view boolean,
  article_create boolean,
  advancement boolean,
  order_create varchar(20),
  bonus_view varchar(20),
  special_bonus_create boolean,
  special_bonus_view boolean,
  campaign_create boolean,
  campaign_view boolean,
  promotion_create boolean,
  promotion_view boolean,
  distributor_create varchar(20),
  distributor_view varchar(20),
  distributor_personal_change varchar(20),
  distributor_personal_view varchar(20),
  distributor_address_change varchar(20),
  distributor_address_view varchar(20),
  distributor_finance_change varchar(20),
  distributor_finance_view varchar(20),
  distributor_intern_view varchar(20),
  distributor_intern_create varchar(20),
  bonus_list_view varchar(20) default 'ST'
  
);

