/*
 * 
 * Created on May 25, 2005
 * 
 * Gy�rgy S�veges
 * Etixpert Kft.
 * Copyright(c) 2005
 * 
 */
package com.etixpert.evolution;


import java.sql.*;
import java.util.*;
import org.hibernate.*;
/**
 * @author Suveges Gyorgy
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ObjectSearch {
    private String table;
    private List PK;
    private String query="";
    private String whereClause;
    private Integer limit;
    private Integer offset;
    private String[] orderBy;
    
   
    
    public ObjectSearch() {
        
    }
    /**
     * 
     */
    
    public void setTable(String table) {
        this.table = table;
        query = "select * from "+table;
    }
    
    public ObjectSearch(String table, List PK) {
        
        this.PK = PK;
        setTable(table);
        
    }
    
    public ObjectSearch(String table, String[] PK) {
        this(table, (List) null); 
        List l = new ArrayList();
        for (int i=0; i<PK.length; i++) l.add(PK[i]);
        this.PK = l;
        
    }
    
    public ObjectSearch(String table, String PK) {
        this(table, new String[]{PK});
    }
   
    public void setCondition(String cond) {
        this.whereClause = cond;
    }
    
    public void setLimit(Integer limit) {
        this.limit = limit;
    }
    
    public void setOffset(Integer offset) {
        this.offset = offset;
    }
    
    public void setOrderBy(String[] attrs) {
        this.orderBy = attrs;
    }
    
    public List search(Connection conn, String query, Object[] parameters) throws SQLException {
        ArrayList list = new ArrayList();
        PreparedStatement ps = conn.prepareStatement(query);
        if (parameters!=null && parameters.length>0) 
            for (int i =0; i<parameters.length; i++) 
                ps.setObject(i+1, parameters[i]);
        
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Map values = new HashMap();
            PersistableObject.fillInValues(rs, values);
            list.add(new PersistableObject(table, PK, values));
        }
        rs.close();
        ps.close();
        return list;
    }
    public List search(String query, Object[] parameters) throws SQLException {
       
         Session session = HibernateUtil.currentSession();
         Transaction tx = session.beginTransaction();
         Connection conn = session.connection();
         
        List l = search(conn, query, parameters);
        tx.commit();
        HibernateUtil.closeSession();
       
        return l;
    }
    
    
    public List search(Connection conn, Object[] parameters) throws SQLException {
        return search(conn, generateQuery(), parameters);
    }
    public List search(Object[] parameters) throws SQLException {
      return search(generateQuery(), parameters);
    }
    
    
    public List search(Connection conn) throws SQLException {
        return search(conn, (Object[]) null);
    }
    
    
    public List search() throws SQLException {
        return search((Object[])null);
    }
    
    
    public List search(Connection conn, String query) throws SQLException {
        return search(conn, query, null);
    }
    
    public List search(String query) throws SQLException {
        return search(query, null);
    }
    
   
    protected String generateQuery() {
        query = "select * from "+table;
        if (whereClause!=null) query+=" where "+whereClause;
        if (orderBy!=null) {
            for (int i=0; i<orderBy.length; i++)
                query+=(i==0?" order by ":",")+orderBy[i];
        }
        if (limit!=null) query+=" limit "+limit;
        if (offset!=null) query+=" offset "+offset;
        
        return query;      
    }
    

}
