/*
 * Test.java
 * Created on May 16, 2005 
 * Author: 	L�szl� Felf�ldi, Etixpert GmbH
 * mail:	laszlo.felfoldi@etixpert.com		
 */
package com.etixpert.evolution.app.bonus;

import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.hibernate.Session;
import org.hibernate.Transaction;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

import com.etixpert.evolution.HibernateUtil;
import com.etixpert.evolution.event.CloseEvent;
import com.etixpert.evolution.event.OrderEvent;
import com.etixpert.evolution.value.CountryValue;
import com.etixpert.evolution.value.DistributorValue;
import com.etixpert.evolution.value.bonus.BonusDefinitionValue;

public class Test {
	public static void main(String[] args) {
		try {			
			if (args.length > 0) {
				SAXBuilder builder = new SAXBuilder();
			
				Document doc = builder.build(args[0]);
				BonusDefinitionValue.fromXML(doc);
				
				Document doc2 = builder.build(args[1]);
				Map environment = DistributorValue.fromXML(doc2.getRootElement(), DistributorValue.FLAG_NEED_ALL);
				
				Document doc3 = builder.build(args[2]);
				List orders = OrderEvent.fromXML(doc3, environment);
				
				// send order events
				OrderEvent event = null;
				for (Iterator it = orders.iterator(); it.hasNext(); ) {
					event = (OrderEvent) it.next();
					Engine.handleEvent(event, environment);
				}
				
				// send close event
				if (event != null) {
					CloseEvent cEvent = new CloseEvent(event.getEventDate(), (DistributorValue) environment.get(""));
					Engine.handleEvent(cEvent, environment);
				}
				
				Document doc4 = new Document();
				Element root = new Element("evolution");
				doc4.setRootElement(root);
				Element names = new Element("names");
				DistributorValue.toXML(environment, names);
				root.addContent(names);
				Element levelDesc = (Element) doc2.getRootElement().getChild("levels").clone();
				Engine.toXML(levelDesc);
				root.addContent(levelDesc);
				root.addContent(BonusData.toXML(environment));
				
				StringWriter sw = new StringWriter();
			    Format format = Format.getRawFormat();
			    format.setEncoding("ISO-8859-1");
			    XMLOutputter outputter = new XMLOutputter(format);
			    outputter.output(doc4, System.out);
			} else {
				Calendar c = Calendar.getInstance();
				c.setTime(new Date(0));
				c.set(Calendar.YEAR, 2014);
				c.set(Calendar.MONTH, 6);
//				BonusAction.correctDatabase(c.getTime());
				
//				BonusAction.accept(c.getTime(), "WEB-INF");

				Object[] res = BonusAction.generate(c.getTime(), new Date(), "WEB-INF", new StringBuffer());
				FileOutputStream fos1 = new FileOutputStream("y1.pdf");
				fos1.write((byte[]) res[5]);
				fos1.close();
				FileOutputStream fos2 = new FileOutputStream("y2.pdf");
				fos2.write((byte[]) res[7]);
				fos2.close();			
				FileOutputStream fos3 = new FileOutputStream("SEPA_AT.dat");
				fos3.write(((String) res[4]).getBytes("UTF8"));
				fos3.close();
				FileOutputStream fos4 = new FileOutputStream("SEPA_DE.dat");
				fos4.write(((String) res[6]).getBytes("UTF8"));
				fos4.close();
//				
//				for (Iterator i = ((Map) res[4]).entrySet().iterator(); i.hasNext();) {
//					Map.Entry item = (Map.Entry) i.next();
//					FileOutputStream fos3 = new FileOutputStream("y_" + item.getKey() + ".pdf");
//					fos3.write((byte[]) item.getValue());
//					fos3.close();			
//				}
				
				
//				BonusAction.storeAll(val, Calendar.getInstance().getTime());
				
//				String res = BonusList.generate(new Integer(0), new Integer(0), BonusList.getMonthBegin(c.getTime()).getTime(), BonusList.TYPE_BONUSLIST, "WEB-INF");
//				FileWriter fw = new FileWriter("y.html");
//				fw.write(res);
//				fw.close();

//				String res = BonusList.generate(new Integer(49000541), new Integer(0), c.getTime(), BonusList.TYPE_BONUSDETAIL, "WEB-INF");
//				FileWriter fw = new FileWriter("z.html");
//				fw.write(res);
//				fw.close();
				
//				String res2 = BonusList.generate(new Integer(0), new Integer(0), BonusList.getMonthBegin(c.getTime()).getTime(), BonusList.TYPE_ORGANIZATION, "WEB-INF");
//				FileWriter fw2 = new FileWriter("x.html");
//				fw2.write(res2);
//				fw2.close();	
//				
//				byte[] res = BonusList.generatePDF(new Integer(0), new Integer(0), c.getTime(), BonusList.TYPE_BONUSLIST, "WEB-INF");
//				FileOutputStream fos = new FileOutputStream("y.pdf");
//				fos.write(res);
//				fos.close();


/*				
				Calendar date = Calendar.getInstance();
				try {
				    date.set(Calendar.MONTH, 11 - 1);
				    date.set(Calendar.YEAR, 2012);
				    date.set(Calendar.DAY_OF_MONTH, 1);
				    date = BonusList.getMonthBegin(date.getTime());
				} catch (Exception e) {
				}
				Date now = Calendar.getInstance().getTime();
				StringBuffer message = new StringBuffer();
				Object[] ret = BonusAction.generate(date.getTime(), now, "WEB-INF", message);
				BonusAction.storeAll(ret, now);
*/
			}
		} catch (Exception e) {
			e.printStackTrace(System.err);
		}
	}
}
