/*
 * BonusReduction.java
 * Created on 2005.06.11.
 * Author:  Laszlo Felfoldi, Etixpert GmbH 
 * mail:    laszlo.felfoldi@etixpert.com
 */
package com.etixpert.evolution.app.bonus.handler;

import java.util.Map;

import org.jdom2.Element;

import com.etixpert.evolution.app.bonus.BonusData;
import com.etixpert.evolution.app.bonus.Handler;
import com.etixpert.evolution.event.Event;
import com.etixpert.evolution.event.OrderEvent;
import com.etixpert.evolution.value.DistributorValue;
import com.etixpert.evolution.value.bonus.BonusDefinitionValue;
import com.etixpert.evolution.value.order.OrderHeaderValue;

public class BonusReduction implements Handler {
	public BonusReduction(BonusDefinitionValue src) {
	}
	
	/* (non-Javadoc)
	 * @see com.etixpert.evolution.app.bonus.Handler#handle(com.etixpert.evolution.event.Event, java.util.Map)
	 */
	public boolean handle(Event event, Map environment) {
		OrderEvent order = (OrderEvent) event;
		DistributorValue dv = event.getEventTarget();
		BonusData bd = dv.getActBonus();
		if (order.getPaymentType().equals(OrderHeaderValue.PAYMENT_METHOD_PROVISIONSMINDERUNG)) {
			bd.addToSpecialBonus(this, "Provisionsminderung", -order.getPrice());
		}
		return true;
	}

	/* (non-Javadoc)
	 * @see com.etixpert.evolution.app.bonus.Handler#toXML(org.jdom.Element)
	 */
	public void toXML(Element to) {
		// TODO Auto-generated method stub
	}

}
