/*
 * CarBonus.java
 * Created on 2005.06.19.
 * Author:  Laszlo Felfoldi, Etixpert GmbH 
 * mail:    laszlo.felfoldi@etixpert.com
 */
package com.etixpert.evolution.app.bonus.handler;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import org.jdom2.Element;

import com.etixpert.evolution.app.bonus.BonusData;
import com.etixpert.evolution.app.bonus.Handler;
import com.etixpert.evolution.event.Event;
import com.etixpert.evolution.value.DistributorValue;
import com.etixpert.evolution.value.bonus.BonusDefinitionValue;

public class CarBonus implements Handler {
	private List values;
	private Map thresholds;
	
	public CarBonus(BonusDefinitionValue src) {
		values = new LinkedList();
		thresholds = new Hashtable();
		
		// Format is bonus1=threshold1,bonus2-threshold2,...?level1:val1,level2:val2,...
		String[] thresholds_vals = src.getData().split("\\?");
		String threshold = thresholds_vals.length < 2 ? "" : thresholds_vals[0];
		String vals = thresholds_vals[thresholds_vals.length < 2 ? 0 : 1];
		
		String[] titems = threshold.split(",");
		for (int j = 0; j < titems.length; j++) {
			String[] bonus_val = titems[j].split("=");
			if (bonus_val.length == 2) 
				thresholds.put(bonus_val[0], new Double(bonus_val[1]));
		}
		
		String[] items = vals.split(",");
		for (int j = 0; j < items.length; j++) {
			String[] limit_val = items[j].split(":");
			values.add(new double[] {Double.parseDouble(limit_val[0]), Double.parseDouble(limit_val[1])});
		}
	}
	
	/* (non-Javadoc)
	 * @see com.etixpert.evolution.app.bonus.Handler#handle(com.etixpert.evolution.event.Event, java.util.Map)
	 */
	public boolean handle(Event event, Map environment) {
		for (Iterator it = environment.values().iterator(); it.hasNext(); ) {
			DistributorValue dv = (DistributorValue) it.next();
			BonusData bd = dv.getActBonus();
			double    val = 0;
			if (bd != null && bd.getLevelId() != null) {
				double    pOV = bd.getpOV();
				for (Iterator it2 = values.iterator(); it2.hasNext(); ) {
					double[] item = (double[]) it2.next();
					if (item[0] <= pOV) val = item[1];
				}
				if (val > 0) {
					// check the conditions
					boolean enabled = true;
					Double limitPV  = (Double) thresholds.get("PV");
					Double limitEV  = (Double) thresholds.get("EV");
					Double limitPEV = (Double) thresholds.get("PEV");
					Double limitTV  = (Double) thresholds.get("TV");
					Double limitOV  = (Double) thresholds.get("OV");
					if (limitPV  != null) enabled &= limitPV .doubleValue() > bd.getpPV(); 
					if (limitEV  != null) enabled &= limitEV .doubleValue() > bd.getpEV(); 
					if (limitPEV != null) enabled &= limitPEV.doubleValue() > bd.getpPEV(); 
					if (limitTV  != null) enabled &= limitTV .doubleValue() > bd.getpTV(); 
					if (limitOV  != null) enabled &= limitOV .doubleValue() > bd.getpOV(); 
					
					bd.addToSpecialBonus("CB", (enabled ? "" : "!") + "Autobonus", val);
				}
			}
		}
		return true;
	}

	/* (non-Javadoc)
	 * @see com.etixpert.evolution.app.bonus.Handler#toXML(org.jdom.Element)
	 */
	public void toXML(Element to) {
	}

}
