/*
 * File name  : Compression.java
 * Package    : com.etixpert.evolution.app.bonus.handler
 * Created on : 02.11.2008
 * Created by : Laszlo Felfoldi (laszlo.felfoldi@etixpert.com)
 */
package com.etixpert.evolution.app.bonus.handler;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import org.jdom2.Element;

import com.etixpert.evolution.app.bonus.BonusData;
import com.etixpert.evolution.app.bonus.Handler;
import com.etixpert.evolution.event.Event;
import com.etixpert.evolution.value.DistributorValue;
import com.etixpert.evolution.value.bonus.BonusDefinitionValue;

public class Compression implements Handler {
	private Map values;

	public Compression(BonusDefinitionValue src) {
		values = new Hashtable();
	
		// Format is level1:depth11=factor11,depth12=factor12,...;level2:depth21=...
		String[] rowitems = src.getData().split(";");
		for (int i = 0; i < rowitems.length; i++) {
			String[] name_sect = rowitems[i].split(":");
			Map entries = new Hashtable();
			values.put(BonusDefinitionValue.getLevel(name_sect[0]), entries);
			if (name_sect.length > 1) {
				String[] items = name_sect[1].split(",");
				for (int j = 0; j < items.length; j++) {
					String[] name_val = items[j].split("=");
					entries.put(name_val[0], new Double(name_val[1]));
				}
			}
		}
	}

	public boolean handle(Event event, Map environment) {
		Set notActives = new HashSet();

		for (Iterator it = environment.values().iterator(); it.hasNext(); ) {
			DistributorValue adv = (DistributorValue) it.next();
			
			if (values.get(adv.getLevelId()) == null) continue;
			
			BonusData bd = adv.getActBonus();
			if (bd == null) continue;
			for (BonusData bd2 = bd; bd2 != null; bd2 = bd2.getPrev()) 
				if (bd2.isManagerBonusCompressed()) 
					notActives.add(adv);
		}
		
		for (Iterator it = environment.values().iterator(); it.hasNext(); ) {
			DistributorValue dv = (DistributorValue) it.next();
			if (values.get(dv.getLevelId()) == null) continue;
			//if (notActives.contains(dv)) continue;
			BonusData bd = dv.getActBonus();
			for (BonusData bd2 = bd; bd2 != null; bd2 = bd2.getPrev()) {
				double bonus  = bd2.getbTV();
				double points = bd2.getpTV();
				BonusData bd3 = bd2;
				for (int level = 1, alevel = 0;(bd3 = bd3.getSponsorData()) != null; level++) {
					if (bd3.getLevelId() == null) break;
					if (!notActives.contains(bd3.getDistributor())) alevel++;
					if (level > alevel) {
						Map row = (Map) values.get(bd3.getLevelId());
						if (row == null) {
							row = (Map) values.get("");
						}
						if (row != null && !notActives.contains(bd3.getDistributor())) {
							Double fac = (Double) row.get("" + level);
							if (fac == null) fac = (Double) row.get("");
							Double afac = (Double) row.get("" + alevel);
							if (afac == null) afac = (Double) row.get("");
							
							double percent = (afac != null ? afac.doubleValue() : 0) - (fac != null ? fac.doubleValue() : 0);
							double val = (int) (percent * bonus) * .01;
							System.err.println("Compression bonus " + dv.getId() + "(" + level + "->" + alevel + ") " + val + " to " + bd3.getDistributor().getId());
							bd3.addToManagerBonus(val);
							bd3.addComment("Kompression", "" + dv.getId(), level + "->" + alevel, points, bonus, percent, val);
						}
					}
				}
			}
			
		}
		return true;
    }

	public void toXML(Element to) {
		// TODO Auto-generated method stub

	}

}
