/*
 * CustomerService.java
 * Created on 2005.06.11.
 * Author:  Laszlo Felfoldi, Etixpert GmbH 
 * mail:    laszlo.felfoldi@etixpert.com
 */
package com.etixpert.evolution.app.bonus.handler;

import java.util.Iterator;
import java.util.Map;

import org.jdom2.Element;

import com.etixpert.evolution.app.bonus.BonusData;
import com.etixpert.evolution.app.bonus.Handler;
import com.etixpert.evolution.event.Event;
import com.etixpert.evolution.value.DistributorValue;
import com.etixpert.evolution.value.bonus.BonusDefinitionValue;

public class CustomerService implements Handler {
	double value;
	
	public CustomerService(BonusDefinitionValue src) {
		value = 0;
		try {
			value = Double.parseDouble(src.getData());
		} catch (Exception e) {}
	}
	/* (non-Javadoc)
	 * @see com.etixpert.evolution.app.bonus.Handler#handle(com.etixpert.evolution.event.Event, java.util.Map)
	 */
	public boolean handle(Event event, Map environment) {
		for (Iterator it = environment.values().iterator(); it.hasNext(); ) {
			DistributorValue dv = (DistributorValue) it.next();
			BonusData bd = dv.getActBonus();
			
			if (bd == null || !dv.getCustomerService()) continue;
			
			double available = 0;
			while (bd != null) {
			    available += bd.getTradeMarginBonus() + bd.getbCV();
			    bd = bd.getPrev();
			}			    
			
			available = Math.round(available * 100) * 0.01;
			if (available > 0) {
			    dv.getActBonus().addToSpecialBonus(this, "Kundenservice", value < available ? -value : -available);
			}
		}
		return false;
	}

	/* (non-Javadoc)
	 * @see com.etixpert.evolution.app.bonus.Handler#toXML(org.jdom.Element)
	 */
	public void toXML(Element to) {
	}
}
