/*
 * ExtraBonus.java
 * Created on May 29, 2005 
 * Author: 	L�szl� Felf�ldi, Etixpert GmbH
 * mail:	laszlo.felfoldi@etixpert.com		
 */
package com.etixpert.evolution.app.bonus.handler;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import org.jdom2.Element;

import com.etixpert.evolution.app.bonus.BonusData;
import com.etixpert.evolution.app.bonus.Handler;
import com.etixpert.evolution.event.Event;
import com.etixpert.evolution.value.DistributorValue;
import com.etixpert.evolution.value.bonus.BonusDefinitionValue;

public class GeneralBonus implements Handler {
	private Set    levels;
	private Object limitMetricId;
	private double limit;
	private Object calcMetric;
	private double factor;
	
	public GeneralBonus(BonusDefinitionValue src) {
		// Condition format is level1,leve2,...leveln:Metrics-limit
		try {
			String[] levels_conds = src.getCondition().split(":");
			String[] aLevels = levels_conds[0].split(",");
			levels = new HashSet();
			for (int i = 0; i < aLevels.length; i++) {
				levels.add(BonusDefinitionValue.getLevel(aLevels[i]));
			}
			String[] id_val = levels_conds[1].split("=");
			limitMetricId = id_val[0];
			limit = Double.parseDouble(id_val[1]);
		} catch (Exception e) {
		}
		
		// Data is factor*Metric
		String[] fac_levels = src.getData().split("\\*");
		try {
			factor = Double.parseDouble(fac_levels[0]) * 0.01;
			calcMetric = fac_levels[1];
		} catch (Exception e) {
		}
	}
	
	
	/* (non-Javadoc)
	 * @see com.etixpert.evolution.app.bonus.Handler#handle(com.etixpert.evolution.event.Event, java.util.Map)
	 */
	public boolean handle(Event event, Map environment) {
		for (Iterator it = environment.values().iterator(); it.hasNext(); ) {
			DistributorValue dv = (DistributorValue) it.next();
			BonusData        bd = dv.getActBonus(); 
			
			if (bd != null && bd.getLevelId() != null && levels.contains(bd.getLevelId())) {
				// get the limit related data 			
				double actPoint = 0;
				if (limitMetricId.equals("PV"))  actPoint = bd.getpPV();  
				if (limitMetricId.equals("EV"))  actPoint = bd.getpEV();  
				if (limitMetricId.equals("PEV")) actPoint = bd.getpPEV();  
				if (limitMetricId.equals("TV"))  actPoint = bd.getpTV();  
				if (limitMetricId.equals("OV"))  actPoint = bd.getpOV();
				
				// there is not enough point to get this bonus
				if (actPoint >= limit) {
					String name = "3% PEV Sonderbonus";
					if (calcMetric.equals("PV"))  bd.addToSpecialBonus(this, name, bd.getbPV()  * factor);
					if (calcMetric.equals("EV"))  bd.addToSpecialBonus(this, name, bd.getbEV()  * factor);
					if (calcMetric.equals("PEV")) bd.addToSpecialBonus(this, name, bd.getbPEV() * factor);
					if (calcMetric.equals("TV"))  bd.addToSpecialBonus(this, name, bd.getbTV()  * factor);
					if (calcMetric.equals("OV"))  bd.addToSpecialBonus(this, name, bd.getbOV()  * factor);
				}
			}			
		}
		return true;
	}

	/* (non-Javadoc)
	 * @see com.etixpert.evolution.app.bonus.Handler#toXML(org.jdom.Element)
	 */
	public void toXML(Element to) {
	}
}
