/*
 * IndividualBonus.java
 * Created on 2005.06.05.
 * Author:  Laszlo Felfoldi, Etixpert GmbH 
 * mail:    laszlo.felfoldi@etixpert.com
 */
package com.etixpert.evolution.app.bonus.handler;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.jdom2.Element;

import com.etixpert.evolution.app.bonus.BonusData;
import com.etixpert.evolution.app.bonus.Handler;
import com.etixpert.evolution.event.Event;
import com.etixpert.evolution.value.DistributorValue;
import com.etixpert.evolution.value.bonus.BonusDefinitionValue;
import com.etixpert.evolution.value.bonus.IndividualBonusValue;

public class IndividualBonus implements Handler {
	public IndividualBonus(BonusDefinitionValue src) {
	}
	
	/* (non-Javadoc)
	 * @see com.etixpert.evolution.app.bonus.Handler#handle(com.etixpert.evolution.event.Event, java.util.Map)
	 */
	public boolean handle(Event event, Map environment) {
		Date eventDate = event.getEventDate();
		for (Iterator it = environment.values().iterator(); it.hasNext(); ) {
			DistributorValue dv = (DistributorValue) it.next();
			BonusData        bd = dv.getActBonus(); 
			List handlers = dv.getBonusHandlers();
			
			if (handlers == null || bd == null) continue;
			
			for (Iterator it2 = handlers.iterator(); it2.hasNext(); ) {
				IndividualBonusValue bv = (IndividualBonusValue) it2.next();
				// stop scanning if the validTo is expired already
				if (bv.getValidTo().before(eventDate)) break;
				
				String qMetric = bv.getQMetric();
				int    qType   = bv.getQType();
				double aqVal   = 0;
				
				if (qMetric.equals("PV")) {
					aqVal = qType == 0 ? bd.getpPV() : qType == 1 ? bd.getbPV() : bd.getxPV();
				} else if (qMetric.equals("EV")) {
					aqVal = qType == 0 ? bd.getpEV() : qType == 1 ? bd.getbEV() : bd.getxEV();			
				} else if (qMetric.equals("PEV")) {
					aqVal = qType == 0 ? bd.getpPEV() : qType == 1 ? bd.getbPEV() : bd.getxPEV();
				} else if (qMetric.equals("TV")) {
					aqVal = qType == 0 ? bd.getpTV() : qType == 1 ? bd.getbTV() : bd.getxTV();
				} else if (qMetric.equals("OV")) {
					aqVal = qType == 0 ? bd.getpOV() : qType == 1 ? bd.getbOV() : bd.getxOV();
				}
	
				// there is not enough value to get this bonus
				if (aqVal < bv.getQValue()) continue;
				
				String cMetric = bv.getCalcMetric();
				int    cType   = bv.getCalcType();
				double cValue  = bv.getCalcValue();
				int    cVType  = bv.getCalcValueType(); 
				
				double bonus = 0;
				if (cVType == 0) {
					if (cMetric.equals("PV")) {
						bonus += cType == 0 ? bd.getpPV() : cType == 1 ? bd.getbPV() : bd.getxPV();
					} else if (cMetric.equals("EV")) {
						bonus += cType == 0 ? bd.getpEV() : cType == 1 ? bd.getbEV() : bd.getxEV();
					} else if (cMetric.equals("PEV")) {
						bonus += cType == 0 ? bd.getpPEV() : cType == 1 ? bd.getbPEV() : bd.getxPEV();
					} else if (cMetric.equals("TV")) {
						bonus += cType == 0 ? bd.getpTV() : cType == 1 ? bd.getbTV() : bd.getxTV();
					} else if (cMetric.equals("OV")) {
						bonus += cType == 0 ? bd.getpOV() : cType == 1 ? bd.getbOV() : bd.getxOV();
					}
					
					if (bonus > 0) {
						bd.addToSpecialBonus(bv, bv.getDescription(), bonus * cValue * .01);
					}
				} else {
					bd.addToSpecialBonus(bv, bv.getDescription(), cValue);
				}
			}
		}
		return true;
	}

	/* (non-Javadoc)
	 * @see com.etixpert.evolution.app.bonus.Handler#toXML(org.jdom.Element)
	 */
	public void toXML(Element to) {
	}
}
