/*
 * OrderBonus.java
 * Created on May 17, 2005 
 * Author: 	L�szl� Felf�ldi, Etixpert GmbH
 * mail:	laszlo.felfoldi@etixpert.com		
 */
package com.etixpert.evolution.app.bonus.handler;

import java.util.Map;

import org.jdom2.Element;

import com.etixpert.evolution.app.bonus.Engine;
import com.etixpert.evolution.app.bonus.Handler;
import com.etixpert.evolution.event.Event;
import com.etixpert.evolution.event.OrderEvent;
import com.etixpert.evolution.event.PropagateEvent;
import com.etixpert.evolution.value.DistributorValue;
import com.etixpert.evolution.value.bonus.BonusDefinitionValue;

public class InitOrder implements Handler {
	public InitOrder(BonusDefinitionValue src) {
		
	}
	
	/* (non-Javadoc)
	 * @see com.etixpert.evolution.app.bonus.Handler#handle(com.etixpert.evolution.common.Event, java.util.Map)
	 */
	public boolean handle(Event event, Map environment) {
		OrderEvent orderevent = (OrderEvent) event;
		// get sponsor data as eventTarget
		
		DistributorValue eventTarget = orderevent.getOrderer();
		if (eventTarget != null) {
			double addVal = orderevent.getPoint();
			double bonusFactor = orderevent.getBonus() / (orderevent.getPoint() !=  0 ? orderevent.getPoint() : 1);
			double priceFactor = orderevent.getPrice() / (orderevent.getPoint() !=  0 ? orderevent.getPoint() : 1);
			double tradeMarginFactor = orderevent.getTradeMargin() / (orderevent.getPoint() !=  0 ? orderevent.getPoint() : 1);
			do {
				PropagateEvent newEvent = new PropagateEvent(event.getEventDate(), eventTarget, 
					 eventTarget, bonusFactor, priceFactor, tradeMarginFactor, addVal);
				Engine.handleEvent(newEvent, environment);
				addVal -= newEvent.getPoint();
			} while (addVal > 0);
		}
		return true;
	}

	public void toXML(Element to) {
	}
}
