/*
 * ManagerBonus.java
 * Created on May 9, 2005 
 * Author: 	L�szl� Felf�ldi, Etixpert GmbH
 * mail:	laszlo.felfoldi@etixpert.com		
 */
package com.etixpert.evolution.app.bonus.handler;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

import org.jdom2.Element;

import com.etixpert.evolution.app.bonus.Handler;
import com.etixpert.evolution.event.Event;
import com.etixpert.evolution.event.PropagateEvent;
import com.etixpert.evolution.value.DistributorValue;
import com.etixpert.evolution.value.bonus.BonusDefinitionValue;

public class ManagerBonus implements Handler {
	private static String KEYNAME_MANAGERLEVEL = "MANAGERLEVEL";
	private Map values;
	
	public ManagerBonus(BonusDefinitionValue src) {
		values = new Hashtable();
	
		// Format is level1:depth11=factor11,depth12=factor12,...;level2:depth21=...
		String[] rowitems = src.getData().split(";");
		for (int i = 0; i < rowitems.length; i++) {
			String[] name_sect = rowitems[i].split(":");
			Map entries = new Hashtable();
			values.put(BonusDefinitionValue.getLevel(name_sect[0]), entries);
			if (name_sect.length > 1) {
				String[] items = name_sect[1].split(",");
				for (int j = 0; j < items.length; j++) {
					String[] name_val = items[j].split("=");
					entries.put(name_val[0], new Double(name_val[1]));
				}
			}
		}
	}
	
	/* (non-Javadoc)
	 * @see com.etixpert.evolution.app.bonus.Handler#handle(com.etixpert.evolution.common.Event, java.util.Map)
	 */
	public boolean handle(Event event, Map environment) {
		PropagateEvent propagateEvent = (PropagateEvent) event;
		
		// enter only when it is a manager, but the sender is not manager or it is the orderer
		DistributorValue dv = event.getEventTarget();
		if (values.containsKey(dv.getLevelId()) &&
				(!values.containsKey(propagateEvent.getFrom().getLevelId()) ||
				  propagateEvent.getOrderer().equals(dv))) {
			// add ManagerValues for its upline
			int level = 1;
			for (DistributorValue ad = event.getEventTarget().getSponsor(); ad != null; ad = ad.getSponsor()) {
				if (ad.getLevelId() == null) break;
				Map row = (Map) values.get(ad.getLevelId());
				if (row == null) {
					row = (Map) values.get("");
				}
				if (row != null) {
					Double val = (Double) row.get("" + level);
					if (val == null) {
						val = (Double) row.get("");
					}
					if (val != null) {
						ad.getActBonus().addToManagerBonus(propagateEvent.getBonus() * val.doubleValue() * .01);
						System.err.println("ManagerBonus:" + ad.getId() + "," + ad.getLevelId() + "(" + level + "=" + event.getEventTarget().getId() + " ," + event.getEventTarget().getLevelId() + ") " + val.doubleValue() + "*" + propagateEvent.getBonus());						
					}
				}
				level++;
			}
		}
		return true;
	}
	
	public void toXML(Element e) {
		for (Iterator it = e.getChildren().iterator(); it.hasNext();) {
			Element item = (Element) it.next();
			Object levelId = BonusDefinitionValue.getLevelInt(item.getAttributeValue("Id"));
			Map row = (Map) values.get(levelId);
			if (row == null) {
				row = (Map) values.get("");
			}
			if (row != null) {
				if (row.isEmpty()) {
					item.addContent(new Element("MB"));
				}
				for (Iterator it2 = row.keySet().iterator(); it2.hasNext(); ) {
					Object level = it2.next();
					Element newElement = new Element("MB");
					Double val = (Double) row.get(level);
					newElement.setAttribute("Level", level.toString());
					newElement.setAttribute("value", "" + val.doubleValue());
					item.addContent(newElement);
				}
			}
		}
	}
}
