/*
 * Bill.java
 * Created on 2005.05.29.
 * Author:  Laszlo Felfoldi, Etixpert GmbH 
 * mail:    laszlo.felfoldi@etixpert.com
 */
package com.etixpert.evolution.app.order;

import java.io.BufferedReader;
import java.io.FileReader;
import java.sql.Connection;

import org.hibernate.Session;
import org.hibernate.Transaction;
import org.jdom2.Document;
import org.jdom2.Element;


import com.etixpert.evolution.HibernateUtil;
import com.etixpert.evolution.app.utils.XMLUtils;
import com.etixpert.evolution.gui.servlets.MainControl;
import com.etixpert.evolution.value.order.OrderHeaderValue;

public class Bill {
	public static String xslt  = null;
	public static String xslt2 = null;
	
	public static byte[] generate(Object id, String path)  {
        Session session = HibernateUtil.currentSession();
        Transaction tx = session.beginTransaction();
        Connection conn = session.connection();
        
        // get the orderheaderValue
	    try {
	    	// load the xsl file if necessary
	    	if (true /*xslt == null*/) {
	    		StringBuffer sb = new StringBuffer();
				BufferedReader reader = new BufferedReader(new FileReader(path+"/xsl/pdf/bill.xsl"));
				for (String line = null; (line = reader.readLine()) != null; sb.append(line));
				xslt = sb.toString().replaceAll("WEB-INF", path);
	    	}
	    	
			OrderHeaderValue ov = OrderHeaderValue.getById(conn, id, OrderHeaderValue.FLAG_NEED_ADDRESS |
																	 OrderHeaderValue.FLAG_NEED_DETAILS);
			if (ov == null) {
				MainControl.logger.info("OH NULL!");
				return null;
			}
			if (ov.getPaymentMethodId().equals(OrderHeaderValue.PAYMENT_METHOD_PROVISIONSMINDERUNG)) return null;
			
			// get its xml representation 
			Document doc = new Document();
			doc.setRootElement(new Element("order"));
			ov.toXML(doc.getRootElement(), OrderHeaderValue.FLAG_NEED_ADDRESS |	 OrderHeaderValue.FLAG_NEED_DETAILS);
			
			return XMLUtils.transformPDF(doc, xslt);
	    } catch (Exception e) {
	    	e.printStackTrace(System.err);
	    	MainControl.logger.info("Error", e);
	    	return null;
	    	//throw e;
	    }
	}
	
	public static byte[] generate2(Object[] ids, String path) throws Exception {
        Session session = HibernateUtil.currentSession();
        Transaction tx = session.beginTransaction();
        Connection conn = session.connection();
        
        // filter: shipping == "Paketdienst"
        // order_id = 21904
        // get the orderheaderValue
	    try {
	    	// load the xsl file if necessary
	    	if (true /*xslt2 == null*/) {
	    		StringBuffer sb = new StringBuffer();
				BufferedReader reader = new BufferedReader(new FileReader(path+"/xsl/pdf/bill2.xsl"));
				for (String line = null; (line = reader.readLine()) != null; sb.append(line));
				xslt2 = sb.toString().replaceAll("WEB-INF", path);
	    	}
	    	
			Document doc = new Document();
			Element  root = new Element("orders");
			doc.setRootElement(root);

			for (int i = 0; i < ids.length; i++) {
				OrderHeaderValue ov = OrderHeaderValue.getById(conn, ids[i], OrderHeaderValue.FLAG_NEED_ADDRESS |
						OrderHeaderValue.FLAG_NEED_DETAILS);
				if (ov == null) {
					MainControl.logger.info("OH NULL!");
					return null;
				}
				if (!ov.getShipping().equals("Paketdienst")) continue;
			
				// get its xml representation 
				Element order = new Element("order");
				ov.toXML(order, OrderHeaderValue.FLAG_NEED_ADDRESS |	 OrderHeaderValue.FLAG_NEED_DETAILS);
				root.addContent(order);
			}
			
			if (root.getChildren().size() == 0) {
				// generating empty error page
				Element message = new Element("message");
				message.setText("Keine BESTELLUNG mit PAKETDIENST ausgew\u00E4hlt!");
				root.addContent(message);
			}
			return XMLUtils.transformPDF(doc, xslt2);
	    } catch (Exception e) {
	    	e.printStackTrace(System.err);
	    	MainControl.logger.info("Error", e);
	    	throw e;
	    }
		//return null;
	}
}
