/*
 * test.java
 * Created on May 29, 2005 
 * Author: 	L�szl� Felf�ldi, Etixpert GmbH
 * mail:	laszlo.felfoldi@etixpert.com		
 */
package com.etixpert.evolution.app.order;

import java.io.FileOutputStream;
import java.io.FileWriter;
import java.sql.Connection;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

import org.hibernate.Session;
import org.hibernate.Transaction;

import com.etixpert.evolution.HibernateUtil;
import com.etixpert.evolution.app.utils.PDFUtils;
import com.etixpert.evolution.workflow.Status20To30;

public class Test {
	public static void main(String[] args) {
		try {			
			Set orders = new HashSet();
			for (int i = 0; i < args.length; i++) {
				//FileOutputStream fo = new FileOutputStream("bill" + args[i] + ".pdf");
				//fo.write(Bill.generate(Integer.parseInt(args[0]), "web/WEB-INF"));
				//fo.close();
				orders.add(new Long(args[i]));
			}
 			Calendar cal = Calendar.getInstance();
	        
			Session session = HibernateUtil.currentSession();
	        Transaction tx = session.beginTransaction();
	        Connection conn = session.connection();
			
	        HashSet firstSepaTransactions = new HashSet();
	        Object[] res = Payment.generate(conn, cal.getTime(), orders, firstSepaTransactions, "WEB-INF");
			Status20To30.setFirstSepaTransactions(conn, firstSepaTransactions);
	        tx.commit();
			
			String timestamp = "" + (cal.get(Calendar.YEAR) % 100) +
				("" + (101 + cal.get(Calendar.MONTH))).substring(1) +
				("" + (100 + cal.get(Calendar.DAY_OF_MONTH))).substring(1) +
				("" + (100 + cal.get(Calendar.HOUR))).substring(1) +
				("" + (100 + cal.get(Calendar.MINUTE))).substring(1) +
				("" + (100 + cal.get(Calendar.SECOND))).substring(1);
			
			FileWriter fw;
			FileOutputStream fos;
			Vector v = new Vector();
			
			if (res[0] != null) {
				fw = new FileWriter("AT_" + timestamp + ".dat");
				fw.write((String) res[0]);
				fw.close();
				
				fos = new FileOutputStream("AT_" + timestamp + ".x1");
				fos.write(((String) res[0]).getBytes());
				fos.close();

				fos = new FileOutputStream("AT_" + timestamp + ".x2");
				fos.write(((String) res[0]).getBytes("ISO-8859-1"));
				fos.close();
			}
			if (res[1] != null) {
				fos = new FileOutputStream("AT_" + timestamp + ".pdf");
				fos.write((byte[])res[1]);
				v.add(res[1]);
				fos.close();
			}
			
			if (res[2] != null) {
				fw = new FileWriter("ATALT_" + timestamp + ".dat");
				fw.write((String) res[2]);
				fw.close();
			}
			if (res[3] != null) {
				fos = new FileOutputStream("AT_" + timestamp + ".pdf");
				fos.write((byte[])res[3]);
				v.add(res[3]);
				fos.close();
			}
			
			if (res[4] != null) {
				fw = new FileWriter("DE_" + timestamp + ".dat");
				fw.write((String)res[4]);
				fw.close();
			}
			if (res[5] != null) {
				fos = new FileOutputStream("DE_" + timestamp + ".pdf");
				fos.write((byte[])res[5]);
				v.add(res[5]);
				fos.close();
			}
			
			if (res[6] != null) {
				fos = new FileOutputStream("CC_" + timestamp + ".pdf");
				fos.write((byte[])res[6]);
				v.add(res[6]);
				fos.close();
			}
			
			if (v.size() > 0) {
				fos = new FileOutputStream("concatenated.pdf");
				fos.write(PDFUtils.concatenate(v.toArray()));
				fos.close();
			}		
		} catch (Exception e) {
			e.printStackTrace(System.err);
		}
	}
}
