/*
 * CreditCard.java
 * Created on Jun 9, 2005 
 * Author: 	L�szl� Felf�ldi, Etixpert GmbH
 * mail:	laszlo.felfoldi@etixpert.com		
 */
package com.etixpert.evolution.app.statistics;

import java.io.BufferedReader;
import java.io.FileReader;
import java.sql.Connection;
import java.util.List;
import java.util.Map;

import org.hibernate.Session;
import org.hibernate.Transaction;
import org.jdom2.Document;
import org.jdom2.Element;

import com.etixpert.evolution.HibernateUtil;
import com.etixpert.evolution.app.utils.ElementFilter;
import com.etixpert.evolution.app.utils.XMLUtils;
import com.etixpert.evolution.value.DistributorValue;

public class DownlineEtiketten {
	private static String xsltPDF = null;
	
	public static class Filter implements ElementFilter {
	    String countryId;
	    String[] roles;
	    String[] partnerTypes;
	    
	    public boolean isElement(Element e) {
	        boolean res = false;
	        String aCountryId = e.getAttributeValue("Country");
	        String aRoleId = e.getAttributeValue("LevelId");
	        
	        String aPartnerType = e.getAttributeValue("PartnerTypeId");
	        if (aPartnerType == null) aPartnerType = "0";

	        if (countryId  != null && !countryId.equals(aCountryId)) 
	            return res;
	        
	        for (int i = 0; i < roles.length; i++) {
	            if (roles[i].equals(aRoleId)) { 
	                res = true; 
	                break;
	            }
	        }
	        
	        if (!res) return false;
	        for (int i = 0; i < partnerTypes.length; i++) {
	            if (partnerTypes[i].equals(aPartnerType)) { 
	                return true;
	            }
	        }
	        return false;
	    }
	    
	    public Filter(String aCountryId, String[] aRoles, String[] aPartnerTypes) {
	        countryId = aCountryId;
	        roles     = aRoles;
	        partnerTypes = aPartnerTypes;
	    }
	    
	}
	

	public static byte[] generatePDF(Object rootId, String orderBy, String[] roles, String[] partner_ids, String countryId, boolean email, boolean email_display, String path, String title1, String title2) {
		Session session = HibernateUtil.currentSession();
		Transaction tx = session.beginTransaction();
		Connection conn = session.connection();
	        
		// get the orderheaderValue
		try {
			// load the xsl file if necessary
			if (xsltPDF == null) {
				StringBuffer sb = new StringBuffer();
				BufferedReader reader = new BufferedReader(new FileReader(path+"/xsl/pdf/DownlineEtiketten.xsl"));
				for (String line = null; (line = reader.readLine()) != null; sb.append(line));
				xsltPDF = sb.toString();
			}
		    	
			int flag = DistributorValue.FLAG_NEED_ADDRESS;
			if (email_display) flag = flag | DistributorValue.FLAG_NEED_EMAIL;
			
			List dv = DistributorValue.getDownlineWithoutDeactivated(conn, rootId, orderBy, flag, email);
			if (dv == null) return null;
				
			// get its xml representation 
			Document doc = new Document();
			Element dst = new Element("names");
			
			DistributorValue.toXML(dv, dst, new Filter(countryId, roles, partner_ids));
			doc.setRootElement(dst);

			Element info = new Element("info");
			info.setAttribute("title1", title1);
			info.setAttribute("title2", title2);
			dst.addContent(info);

			return XMLUtils.transformPDF(doc, xsltPDF);
		} catch (Exception e) {
			e.printStackTrace(System.err);
		}
		return null;
	}
}

