/*
 * CreditCard.java
 * Created on Aug 11, 2005 
 * Author: 	Lszl Felfldi, Etixpert GmbH
 * mail:	laszlo.felfoldi@etixpert.com		
 */
package com.etixpert.evolution.app.statistics;

// Neu-Qualifikation

import java.io.BufferedReader;
import java.io.FileReader;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

import org.hibernate.Session;
import org.hibernate.Transaction;
import org.jdom2.Document;
import org.jdom2.Element;

import com.etixpert.evolution.HibernateUtil;
import com.etixpert.evolution.app.bonus.BonusList;
import com.etixpert.evolution.app.utils.ElementFilter;
import com.etixpert.evolution.app.utils.XMLUtils;
import com.etixpert.evolution.value.DistributorValue;
import com.etixpert.evolution.value.bonus.DistributorHistoryValue;

public class NewQualification {
	private static String xsltHTML = null;
	private static String xsltPDF = null;
	   private static SimpleDateFormat sdf = new SimpleDateFormat("MM.yyyy");

    public static class Filter implements ElementFilter {
	    Map items;
	    public boolean isElement(Element e) {
	        String id = e.getAttributeValue("Id");
	        try {
	            if (items.containsKey(new Integer(id))) {
	                DistributorHistoryValue dhv = (DistributorHistoryValue) items.get(new Integer(id));
	                e.setAttribute("LevelId", "" + dhv.getLevelId());
	                return true;
	            }
	        } catch (Exception ex) {
	        }
	        return false;
	    }
	    
	    public Filter(Map aItems) {
	        items = aItems;
	    }
	}
    
	public static Document generate(Date month, Integer levelId) {
	    Session session = HibernateUtil.currentSession();
		Transaction tx = session.beginTransaction();
		Connection conn = session.connection();
		
		List dv = DistributorValue.getDownline(conn, new Integer(0), "lastname", DistributorValue.FLAG_NEED_ADDRESS);
		if (dv == null) return null;
		
		Map items = DistributorHistoryValue.getByMonthLevelId(conn, month, levelId);

		// get its xml representation 
		Document doc = new Document();
		Element dst = new Element("names");
		
		DistributorValue.toXML(dv, dst, new Filter(items));
		Element root = new Element("evolution");
		doc.setRootElement(root);
		root.addContent(dst);
		root.addContent(BonusList.getLevelInfo(conn));

		// set info items
		Element info = new Element("info");
		root.addContent(info);
		Element infoitem;

		infoitem = new Element("item");
		info.addContent(infoitem);
		infoitem.setAttribute("name", "month");
		infoitem.setAttribute("val", sdf.format(month));

		return doc;
	
	}
	   
    
	public static String generateHTML(Date month, Integer levelId, String path) {		
		try {
			// load the xsl file if necessary
			if (xsltHTML == null) {
				StringBuffer sb = new StringBuffer();
				BufferedReader reader = new BufferedReader(new FileReader(path+"/xsl/html/NewQualification.xsl"));
				for (String line = null; (line = reader.readLine()) != null; sb.append(line));
				xsltHTML = sb.toString();
			}
		    	    
			Document doc = generate(month, levelId);
			return XMLUtils.transform(doc, xsltHTML);
		} catch (Exception e) {
			e.printStackTrace(System.err);
		}
		return null;
	}
	
	public static byte[] generatePDF(Date month, Integer levelId, String path) {
		try {
			// load the xsl file if necessary
			if (xsltPDF == null) {
				StringBuffer sb = new StringBuffer();
				BufferedReader reader = new BufferedReader(new FileReader(path+"/xsl/pdf/NewQualification.xsl"));
				for (String line = null; (line = reader.readLine()) != null; sb.append(line));
				xsltPDF = sb.toString();
			}
		    	    
			Document doc = generate(month, levelId);
			
			return XMLUtils.transformPDF(doc, xsltPDF);
		} catch (Exception e) {
			e.printStackTrace(System.err);
		}
		return null;	}
}
