/*
 * CreditCard.java
 * Created on Jun 8, 2005 
 * Author: 	L�szl� Felf�ldi, Etixpert GmbH
 * mail:	laszlo.felfoldi@etixpert.com		
 */
package com.etixpert.evolution.app.statistics;

import java.io.BufferedReader;
import java.io.FileReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.hibernate.Session;
import org.hibernate.Transaction;
import org.jdom2.Document;
import org.jdom2.Element;

import com.etixpert.evolution.HibernateUtil;
import com.etixpert.evolution.ObjectSearch;
import com.etixpert.evolution.PersistableObject;
import com.etixpert.evolution.app.utils.XMLUtils;
import com.etixpert.evolution.event.CalculateEvent;
import com.etixpert.evolution.value.DistributorValue;
import com.etixpert.evolution.value.order.OrderHeaderValue;

public class TagesProduktion {
    private static String xslt;
    private static String xsltPDF;
    private static SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
    
    private static Document generate(Date date) throws SQLException {
		Session session = HibernateUtil.currentSession();
		Transaction tx = session.beginTransaction();
		Connection conn = session.connection();

		ObjectSearch os = new ObjectSearch();
		List items = os.search(conn, 
		        "Select firstname, lastname, bill_id, d.id As did, " +
		        "case when oh.orderer_level_id=300 or oh.orderer_level_id=330 or oh.orderer_level_id=370 or oh.orderer_level_id=350 then total_netto_trader else oh.total_netto end as total_netto," +
		        "total_bonus, total_points, " +
		        "case when oh.orderer_level_id=300 or oh.orderer_level_id=330 or oh.orderer_level_id=370 or oh.orderer_level_id=350 then total_brutto_trader else oh.total_brutto end as total_brutto " +
		        "From order_header oh Join distributor d On oh.ordered_by=d.id " +
		        "Where billing_date = ? And order_status_id < 90 " +
		        "And d.deleted = false " +
		        "Order by lastname, firstname", 
		        new Object[] {
		        	new java.sql.Date(date.getTime())
		        }
		);
		
		Element root = new Element("TagesProduktion");
		for (Iterator it = items.iterator(); it.hasNext(); ) {
		    PersistableObject po = (PersistableObject) it.next();
		    Element e = new Element("item");
		    e.setAttribute("BillingId", "" + po.get("bill_id"));
		    e.setAttribute("Name", po.get("lastname") + ", " + po.get("firstname"));
		    e.setAttribute("Did", "" + po.get("did"));
		    e.setAttribute("Points", "" + po.get("total_points"));
		    e.setAttribute("Bonus", "" + po.get("total_bonus"));
		    e.setAttribute("Netto", "" + po.get("total_netto"));
		    e.setAttribute("Brutto", "" + po.get("total_brutto"));
		    root.addContent(e);
		}
		
		Document ret = new Document();
		ret.setRootElement(root);

		// set info items
		Element info = new Element("info");
		root.addContent(info);
		Element infoitem;

		infoitem = new Element("item");
		info.addContent(infoitem);
		infoitem.setAttribute("name", "date");
		infoitem.setAttribute("val", sdf.format(date));

		return ret;
    }
    
	public static String generateHTML(Date date, String path) {
		// get the orderheaderValue
		try {
			// load the xsl file if necessary
			//if (xsltPDF == null) {
				StringBuffer sb = new StringBuffer();
				BufferedReader reader = new BufferedReader(new FileReader(path + "/xsl/html/TagesProduktion.xsl"));				
				for (String line = null; (line = reader.readLine()) != null; sb.append(line));
				xsltPDF = sb.toString();
			//}
		    
			Document data = generate(date);
			return date != null ? XMLUtils.transform(data, xsltPDF) : null;
		} catch (Exception e) {
			e.printStackTrace(System.err);
		}
		return null;
	}

	public static byte[] generatePDF(Date date, String path) {
		// get the orderheaderValue
		try {
			// load the xsl file if necessary
			//if (xsltPDF == null) {
				StringBuffer sb = new StringBuffer();
				BufferedReader reader = new BufferedReader(new FileReader(path + "/xsl/pdf/TagesProduktion.xsl"));				
				for (String line = null; (line = reader.readLine()) != null; sb.append(line));
				xsltPDF = sb.toString();
			//}
		    
			Document data = generate(date);
			return data != null ? XMLUtils.transformPDF(data, xsltPDF) : null;
		} catch (Exception e) {
			e.printStackTrace(System.err);
		}
		return null;
	}
}