package com.etixpert.evolution.app.utils;

import java.util.Date;
import java.util.TimeZone;
import java.text.SimpleDateFormat;

public class DateUtil {
    public static Date addWorkingDay(Date date, int wd) {
    	// works only for positive wd values
    	TimeZone tz = TimeZone.getDefault();
    	int offset = tz.getOffset(date.getTime());
    	
    	long l = Math.round((date.getTime() + offset) / (double) (1000 * 60 * 60 * 24));
    	long d = (l + 3) % 7;
    	long r = l + wd;
    	if (d + wd >= 5) {
    		long diff = 5 - d;
    		wd -= diff;
    		l += 2 + diff;
    		r = l + (wd / 5) * 7 + wd % 5;
    	}
    	return new Date(r * 1000 * 60 * 60 * 24 - offset);
    }
    
    public static void main(String[] args) throws Exception {
    	SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmm");
    	System.out.println(df.format(addWorkingDay(df.parse("201406121210"), 7)));
    }
} 
