/*
 * Event.java
 * Created on May 11, 2005 
 * Author: 	Lszl Felfldi, Etixpert GmbH
 * mail:	laszlo.felfoldi@etixpert.com		
 */
package com.etixpert.evolution.event;

import java.util.Date;

import com.etixpert.evolution.value.DistributorValue;

public class Event {
	public static Integer BONUSCALCULATION_ORDER     = new Integer(1);
	public static Integer BONUSCALCULATION_PROPAGATE = new Integer(2);
	public static Integer BONUSCALCULATION_CALCULATE = new Integer(3);
	public static Integer BONUSCALCULATION_CLOSE     = new Integer(4);
	
	protected Object eventId;
	protected Date   eventDate;
	protected DistributorValue eventTarget;
	protected Object eventTargetLevelId;
	
	public Event(Object aEventId, Date aEventDate, DistributorValue aEventTarget) {
		eventId            = aEventId;
		eventDate          = aEventDate;
		eventTarget        = aEventTarget;
		eventTargetLevelId = aEventTarget.getLevelId();
	}
	
	public Object getEventId() {
		return eventId;
	}

	public Date getEventDate() {
		return eventDate;
	}

	public DistributorValue getEventTarget() {
		return eventTarget;
	}

	public void setEventTarget(DistributorValue aTarget) {
		eventTarget = aTarget;
		eventTargetLevelId = aTarget.getLevelId();
	}

	public Object getEventTargetLevelId() {
		return eventTargetLevelId;
	}
}
