/*
 * OrderEvent.java
 * Created on May 12, 2005 
 * Author: 	L�szl� Felf�ldi, Etixpert GmbH
 * mail:	laszlo.felfoldi@etixpert.com		
 */
package com.etixpert.evolution.event;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import org.jdom2.Document;
import org.jdom2.Element;

import com.etixpert.evolution.value.DistributorValue;
import com.etixpert.evolution.value.order.OrderHeaderValue;

public class OrderEvent extends Event {
	static DateFormat dateformat = DateFormat.getDateTimeInstance(DateFormat.SHORT, DateFormat.MEDIUM, Locale.GERMAN);		

	private double bonus;
	private double point;
	private double price;
	private double tradeMargin;
	private Object paymentType;
	private DistributorValue orderer;

	public OrderEvent(Date aEventDate, DistributorValue aOrderer, double aBonus, double aPrice, 
					 double aTradeMargin, double aPoint, Object aPaymentType) {
		super(BONUSCALCULATION_ORDER, aEventDate, aOrderer);
		point       = aPoint;
		price       = aPrice;
		bonus       = aBonus;
		tradeMargin = aTradeMargin;
		orderer     = aOrderer;
		paymentType = aPaymentType;
	}	
	
	public OrderEvent(OrderHeaderValue oh) {
		super(BONUSCALCULATION_ORDER, oh.getBonusDate(), oh.getOrderer());
		point = oh.getTotalNetto(); // not needed anymore
		price = oh.getTotalNetto();
		bonus = oh.getTotalBonus();
		tradeMargin = oh.getTradeMargin();
		orderer = oh.getOrderer();
		paymentType = oh.getPaymentMethodId();
	}
	
	public double getPoint() {
		return point;
	}
	
	public double getBonus() {
		return bonus;
	}
	
	public double getPrice() {
		return price;
	}

	public double getTradeMargin() {
		return tradeMargin;
	}
	
	public DistributorValue getOrderer() {
		return orderer;
	}
	
	public Object getPaymentType() {
		return paymentType;
	}
	
	public static List fromXML(Document doc, Map environment) throws ParseException{
		List ret = new LinkedList();
		List orders = doc.getRootElement().getChildren();
		for (Iterator it = orders.iterator(); it.hasNext(); ) {
			Element e = (Element) it.next();
			Date eventDate = dateformat.parse(e.getAttributeValue("Date"));
			DistributorValue act = (DistributorValue) environment.get(e.getAttributeValue("DistributorId"));
			ret.add(new OrderEvent(eventDate, act,
						  Double.parseDouble(e.getAttributeValue("Bonus")),
						  Double.parseDouble(e.getAttributeValue("Price")),
						  Double.parseDouble(e.getAttributeValue("Point")),
						  Double.parseDouble(e.getAttributeValue("TradeMargin")),
						  new Integer(e.getAttributeValue("PaymentType")))
			);
		}
		return ret;		
	}
}
