/*
 * Propagate.java
 * Created on May 12, 2005 
 * Author: 	L�szl� Felf�ldi, Etixpert GmbH
 * mail:	laszlo.felfoldi@etixpert.com		
 */
package com.etixpert.evolution.event;

import java.util.Date;

import com.etixpert.evolution.value.DistributorValue;

public class PropagateEvent extends Event {
	private double           bonusFactor;
	private double           priceFactor;
	private double           tradeMarginFactor;
	private double           point;
	private DistributorValue from;
	private DistributorValue orderer;

	protected PropagateEvent(Object eventId, PropagateEvent src, double aPoint) {
		super(eventId, src.eventDate, src.eventTarget);
		point = aPoint;
		from  = src.from;
		bonusFactor = src.bonusFactor;
		priceFactor = src.priceFactor;
		tradeMarginFactor = src.tradeMarginFactor;
		orderer = src.orderer;
	}

	public PropagateEvent(DistributorValue aEventTarget, PropagateEvent src, DistributorValue aFrom, double aPoint) {
		super(BONUSCALCULATION_PROPAGATE, src.eventDate, aEventTarget);
		point = aPoint;
		from = aFrom;
		orderer = src.orderer;
		bonusFactor = src.bonusFactor;
		priceFactor = src.priceFactor;
		tradeMarginFactor = src.tradeMarginFactor;
	}
	
	public PropagateEvent(Date aEventDate, DistributorValue aEventTarget, DistributorValue aOrderer, double aBonusFactor, double aPriceFactor, double aTradeMarginFactor, double aPoint) {
		super(BONUSCALCULATION_PROPAGATE, aEventDate, aEventTarget);
		point = aPoint;
		bonusFactor = aBonusFactor;
		priceFactor = aPriceFactor;
		tradeMarginFactor = aTradeMarginFactor;
		orderer = aOrderer;
		from = aOrderer;
	}
	
	public DistributorValue getOrderer() {
		return orderer;
	}
	
	public double getBonus() {
		return point * bonusFactor;
	}

	public double getPrice() {
		return point * priceFactor;
	}

	public double getTradeMargin() {
		return point * tradeMarginFactor;
	}
	
	public double getPoint() {
		return point;
	}
	
	public void setPoint(double aPoint) {
		point = aPoint;
	}
	
	public DistributorValue getFrom() {
		return from;
	}
}
