/*
 *
 * Created on Jul 4, 2005
 *
 * György Süveges
 * Etixpert Kft.
 * Copyright(c) 2005
 *
 */
package com.etixpert.evolution.gui.servlets;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Iterator;
import java.util.Calendar;

import javax.servlet.http.*;

import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.Transaction;

import com.etixpert.evolution.EvolutionException;
import com.etixpert.evolution.HibernateUtil;
import com.etixpert.evolution.ObjectSearch;
import com.etixpert.evolution.PersistableObject;
import com.etixpert.evolution.SuperPO;
import com.etixpert.evolution.AboChecker;
import com.etixpert.evolution.gui.servlets.elements.*;
import com.etixpert.evolution.Tools;
import javax.servlet.jsp.jstl.fmt.*;
import javax.servlet.jsp.*;

import java.text.*;

/**
 * @author Suveges Gyorgy
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class AboHelper {
	public final static int INDEX_CREATE=0;
	public final static int INDEX_VIEW=1;
	public final static int INDEX_MODIFY=2;
	public final static int INDEX_DELETE=3;
	public final static int MASK_CREATE=1;
	public final static int MASK_VIEW=2;
	public final static int MASK_MODIFY=4;
	public final static int MASK_DELETE=8;


    public static List listAbos(Connection conn, Integer did) throws Exception {
        ObjectSearch os = new ObjectSearch();
        return os.search(conn, "select id, creation_date, comment, duration, delivery_intervall, next_delivery, total_netto, total_bonus, total_brutto " +
        		"from subscription_header where distr_id = ?", new Object[]{did});
    }


    public static boolean[] getRights(HttpSession session, String prefix, int mask) throws Exception {
    	Integer did;
    	if (prefix.equals("customer_"))
    		did = new Integer((String) session.getAttribute("CURRENT_CUSTOMER_ID"));
    	else
    		did = new Integer((String) session.getAttribute("CURRENT_DISTRIBUTOR_ID"));

    	Integer uid = new Integer((String) session.getAttribute("USER_LOGGED_ID"));
    	Integer lid = new Integer((String) session.getAttribute("USER_LOGGED_LEVEL_ID"));
    	Transaction tx = null;
    	try {
    		Session hibernateSession = HibernateUtil.currentSession();
    		tx = hibernateSession.beginTransaction();
    		Connection conn = hibernateSession.connection();
    		PersistableObject rights = new PersistableObject("general_rights", "role_id");
    		rights.set("role_id", lid);
    		rights.load(conn);
    		boolean create = false;
    		if ((mask | MASK_CREATE) == mask) create = Tools.getRight(conn, rights, "subscription_create", uid, did);
    		boolean view = false;
    		if ((mask | MASK_VIEW) == mask) view = Tools.getRight(conn, rights, "subscription_view", uid, did);
    		boolean modify = false;
    		if ((mask | MASK_MODIFY) == mask) modify = Tools.getRight(conn, rights, "subscription_modify", uid, did);
    		boolean delete = false;
    		if ((mask | MASK_DELETE) == mask) delete = Tools.getRight(conn, rights, "subscription_delete", uid, did);
    		tx.commit();
    		HibernateUtil.closeSession();
    		return new boolean[]{create, view, modify, delete};

    	}catch (Exception e) {
    		MainControl.logger.error("Error occured. Rolling Back. "+e.getMessage());
    		if (tx!=null)
    			tx.rollback();
    		throw e;
    	}


    }


    public static void newAboStart(HttpSession session, String distr_id, String prefix, boolean promo) throws Exception {
    	//MainControl.logger.info("(TESTING ABOS)");
        int id = Integer.parseInt(distr_id);
    	Map jspMap = new HashMap();

    	jspMap.putAll(getOrderPersonFirst(session, distr_id, prefix, promo));

    	Calendar cc = GregorianCalendar.getInstance();
    	if (promo)
    		cc.add(Calendar.YEAR, 1);
    	else
    		cc.add(Calendar.MONTH, 1);
    	
    	jspMap.put("distr_id", new String[] {distr_id});
    	jspMap.put("start_date", new String[] {DateFormat.getDateInstance(DateFormat.MEDIUM, Locale.GERMAN).format(new java.util.Date())});
    	jspMap.put("duration", new String[] {"12"});
    	jspMap.put("auto_extension", new String[]{"true"});
    	Calendar cal = Calendar.getInstance();
    	

    	
    	int month = cal.get(Calendar.MONTH)+1;
    	//jspMap.put("start_month", new String[]{Integer.toString(month)});
    	int date = cal.get(Calendar.DATE);
    	String ot = null;
    	if (date>=24) ot="4";
    	else if (date>=16) ot="3";
    	else if (date>=8) ot="2";
    	else ot="1";
    	jspMap.put("operating_time",new String[]{ot});
        session.setAttribute(prefix+"new_abo.jsp", jspMap);

	}

    public static String getPrefix(HttpServletRequest req) {
        return (req.getParameter("prefix")==null || req.getParameter("prefix").equals(""))?"user_":req.getParameter("prefix");
    }


    public static String generateAboListHeader(PageContext pageContext, String prefix) throws Exception {
		boolean admin = false;
		boolean distributor = false;
		boolean customer = false;
		boolean specialAgent = false;

		HttpSession session = pageContext.getSession();
		if	(session.getAttribute("admin")!=null) admin = true;
		if	(session.getAttribute("customer")!=null) customer = true;
		if	(session.getAttribute("distributor")!=null) distributor = true;
		if  (session.getAttribute("specialAgent")!=null) specialAgent = true;

		boolean customer_abo = 
		prefix.equals("customer_");
		
		StringBuffer sb = new StringBuffer();
		sb.append("<table id=\"mainTable\" width=\"800\">");
		if (admin || distributor || specialAgent) {
			if (customer_abo) {
				sb.append("<col width=\"35\"/>");
			    sb.append("<col width=\"60\"><col width=\"270\"><col width=\"120\"><col width=\"100\"/><col width=\"60\"/><col width=\"90\"/>"+
				"<col width=\"60\"><col width=\"70\">");
				sb.append("<tr align=\"center\" id=\"accountTableHeaderContent\">");
				sb.append("<td>&nbsp;</td>");
				sb.append("<td>Nr.</td><td>"+pageContext.getAttribute("comment")+"</td><td>"+LocaleSupport.getLocalizedMessage(pageContext, "CREATION_DATE")+"</td><td>Laufzeit</td><td>Lief.Int.</td><td>n&auml;chste Ausl.</td>"+
				"<td>T.Netto</td><td>T.Brutto</td>");
				sb.append("</tr>");
				
			} else {
				sb.append("<col width=\"35\"/>");
			    sb.append("<col width=\"60\"><col width=\"200\"><col width=\"120\"><col width=\"100\"/><col width=\"60\"/><col width=\"90\"/>"+
				"<col width=\"60\"><col width=\"70\">"+
				"<col width=\"70\">");
				sb.append("<tr align=\"center\" id=\"accountTableHeaderContent\">");
				sb.append("<td>&nbsp;</td>");
				sb.append("<td>Nr.</td><td>"+pageContext.getAttribute("comment")+"</td><td>"+LocaleSupport.getLocalizedMessage(pageContext, "CREATION_DATE")+"</td><td>Laufzeit</td><td>Lief.Int.</td><td>n&auml;chste Ausl.</td>"+
				"<td>T.Netto</td><td>T.Bonus</td>" +
				"<td>T.Brutto</td>");
				sb.append("</tr>");
			}
		}
		else if (customer) {
		    sb.append("<col width=\"35\"/>");
		    sb.append("<col width=\"60\"><col width=\"150\"><col width=\"110\"><col width=\"80\"/><col width=\"60\"/><col width=\"90\"/>" +
		    		"<col width=\"70\"/>");
		    sb.append("<td>&nbsp;</td>");
			sb.append("<tr align=\"center\" id=\"dataTableHeaderContent\">");
			sb.append("<td>Nr.</td><td>"+pageContext.getAttribute("comment")+"</td><td>"+LocaleSupport.getLocalizedMessage(pageContext, "CREATION_DATE")+"</td><td>Laufzeit</td><td>Lief.Int.</td><td>n&auml;chste Ausl.</td>"+
			"<td>T.Brutto</td>");
			sb.append("</tr>");
		}
		return sb.toString();
	}

    public static String generateAboListData(HttpSession session, String jsp, List l, String prefix) throws Exception {
        boolean admin = false;
		boolean distributor = false;
		boolean customer = false;
		boolean specialAgent = false;
		if	(session.getAttribute("admin")!=null) admin = true;
		if	(session.getAttribute("customer")!=null) customer = true;
		if	(session.getAttribute("distributor")!=null) distributor = true;
		if  (session.getAttribute("specialAgent")!=null) specialAgent = true;
		
		boolean customer_abo = 
		prefix.equals("customer_");
		
		 StringBuffer sb = new StringBuffer();
		for (int i=0; i<l.size(); i++) {
		   sb.append("<tr>\n");
		    PersistableObject abo = (PersistableObject) l.get(i);
		    CheckBox delbox = new CheckBox(session, jsp, "del", abo.getString("id",""), "", false);
		    sb.append("<td align=\"center\" id=\"accountTableDataContent\">").append(delbox.toHTML()).append("</td>\n");
		    sb.append("<td align=\"center\" id=\"accountTableDataContent\">")
		    	.append("<a href=\"javascript:top.mainFrame.location='process/abo_detail.jsp?id="+abo.getString("id","")+"&saveState=nothing&pageAction=load_abo&link=process/abo_detail.jsp%3fprefix="+prefix+"+&prefix="+prefix+"';\">")
		    	.append(abo.getString("id","")).append("</a></td>\n");


		    sb.append("<td align=\"center\" id=\"accountTableDataContent\">").append(abo.getString("comment","")).append("</td>\n");
		    sb.append("<td align=\"center\" id=\"accountTableDataContent\">").append(OrderListHelper.dateToString((java.sql.Date) abo.get("creation_date"))).append("</td>\n");
		    sb.append("<td align=\"center\" id=\"accountTableDataContent\">").append(abo.getString("duration","")).append(" Mon. </td>\n");
		    sb.append("<td align=\"center\" id=\"accountTableDataContent\">").append(abo.getString("delivery_intervall","")).append(" Mon. </td>\n");
		    sb.append("<td align=\"center\" id=\"accountTableDataContent\">").append(OrderListHelper.dateToString((java.sql.Date) abo.get("next_delivery"))).append("</td>\n");
		    if (!customer) sb.append("<td align=\"right\" id=\"accountTableDataContent\">").append(OrderListHelper.numberToString(abo.get("total_netto"),2)).append("</td>\n");
		    if (!customer && !customer_abo) sb.append("<td align=\"right\" id=\"accountTableDataContent\">").append(OrderListHelper.numberToString(abo.get("total_bonus"),2)).append("</td>\n");
		    sb.append("<td align=\"right\" id=\"accountTableDataContent\">").append(OrderListHelper.numberToString(abo.get("total_brutto"),2)).append("</td>\n");
		    sb.append("</tr>");
		}

		return sb.toString();
    }


    public static Map getOrderPersonFirst(HttpSession session, String distr_id, String prefix, boolean promo) throws Exception {
		Map m = new HashMap();

		PersistableObject po = new PersistableObject("distributor", new String[] {"id"});

		po.set("id", new Integer(distr_id));

		po.load();

		Logger logger = MainControl.logger;

		List addresses = OrderHelper.getAddresses(po);

		m.put("sponsor", new String[] {po.getString("sponsor", "n/a")});
		m.put("tel", new String[] {OrderHelper.generateTels(po)});
		m.put("orderingCountry", new String[] {po.getString("country_code", "")});
		m.put("UID", new String[] {po.getString("vat_id", "")});
		m.put("orderingLevelId", new String[] {po.getString("level_id", "100")});
		m.put("delivery_intervall", new String[] {promo?"12":"1"});

		

		
		Boolean ps = (Boolean)po.get("payment_slip");
		if (ps!=null)
			m.put("payment_slip", ps);		
		
		for (int i = 0; i<addresses.size(); i++) {
			logger.info("Checking addresses i: "+i);
			PersistableObject address = (PersistableObject)addresses.get(i);
			Boolean def_delivery = (Boolean)address.get("default_delivery");
			Boolean def_bill = (Boolean)address.get("default_bill");

			if (def_delivery.booleanValue()) {
				m.put("delivery_postcode", new String[] {address.getString("postcode", "")});
				m.put("delivery_city", new String[] {address.getString("city", "")});
				m.put("delivery_street", new String[] {address.getString("street", "")});
				m.put("delivery_country_id", new String[] {address.getString("country_post_code", "")});
				String delivery_name = address.getString("delivery_name", "");
				if (!delivery_name.equals(""))
					m.put("delivery_name", new String[] {delivery_name});
			}

			if (def_bill.booleanValue()) {
				m.put("billing_postcode", new String[] {address.getString("postcode", "")});
				m.put("billing_city", new String[] {address.getString("city", "")});
				m.put("billing_street", new String[] {address.getString("street", "")});
				m.put("billing_country_id", new String[] {address.getString("country_post_code", "")});
				String delivery_name = address.getString("delivery_name", "");
				if (!delivery_name.equals(""))
					m.put("billing_name", new String[] {delivery_name});
			}
		}
		//logger.info("(TESTING ABO) billing name: "+m.get("billing_name"));
		if (m.get("billing_name")==null || m.get("billing_name").equals("")) {
		    
		    m.put("billing_name", new String[]
		         {OrderHelper.getTitle(po)+po.getString("firstname", "")+" "+po.getString("lastname", "")});
			m.put("billing_title", new String[] {OrderHelper.getLevelAddress(po)});
		}

		//logger.info("(TESTING ABO) delivery name: "+m.get("delivery_name"));
		if (m.get("delivery_name")==null || m.get("delivery_name").equals("")) {
		    
		    m.put("delivery_name", new String[]
		         {OrderHelper.getTitle(po)+po.getString("firstname", "")+" "+po.getString("lastname", "")});
			m.put("delivery_title", new String[] {OrderHelper.getLevelAddress(po)});
			
		}

		PersistableObject country = new PersistableObject("country", "country_code");
		country.set("country_code", po.getString("country_code", ""));
		country.load();

		String freight = country.getString("freight_art_id", "0");

//		if (promo)
//			m.put("pay_method_id", new String[] {po.getString("pay_method_id", "4")});
//		else
//			m.put("pay_method_id", new String[] {"2"});
		
		m.put("pay_method_id", new String[] {po.getString("pay_method_id", "4")});

		m.put("shipping_descr", new String[] {OrderHelper.getShippingDescr(po)});

		String cc = po.getString("country_code", "");
		if (!promo) addNewOrderDetail(session, freight, po.getString("country_code", ""), po.getString("level_id", ""), prefix, po.getString("vat_id", ""));
		
		Map orders = (Map)session.getAttribute(prefix+"new_abo_details");
    	orders.put("ordering_level_id", po.getString("level_id", "100"));
		
//		else
	//		addNewOrderDetail(session, "A"+cc, cc, po.getString("level_id", ""), prefix, po.getString("vat_id", ""), 1);

		return m;
	}

    public static void addNewOrderDetail(HttpSession session, String id, String country_code, String levelStr, String prefix, String uid) throws Exception {
		PersistableObject po = new PersistableObject("currentarticles","id");
		try {
			po.set("id",id);
			po.load();
		} catch(Exception e) {
			session.setAttribute(prefix+"new_abo_error","Keine gültige Artikelnummer");
			return;
		}
		//Map myMap = FormHelper.getArticle(id, MainControl.logger);
		//boolean noVat = uid!=null && uid.length()>0 && "DE".equals(country_code);
		String descr = (String) po.get("descr");
		PersistableObject po_country = new PersistableObject("country", "country_code");
		po_country.set("country_code", country_code);
		po_country.load();
		int level = 100;

		String tax_id = po_country.getString("tax_id", "");
		boolean noVat = uid!=null && uid.length()>0 && !"".equals(tax_id) && !"0".equals(tax_id)
		&& !"AT".equals(country_code);
		
		try {
		   level = Integer.parseInt(levelStr);
		} catch (Exception e) {
		   level = 100;
		}
		Double netto = (Double) po.get("netto");
		Double bonus = (Double) po.get("bonus");
		String vatClass = po.getString("vat_id", "1");

		if (vatClass.equals("0")) vatClass="1";

		Double netto_customer = (Double) po.get("netto_customer");
		Double netto_vip_customer = (Double) po.get("netto_vip_customer");
		BigDecimal vat = (BigDecimal) po_country.get("vat"+vatClass);
		if (noVat) vat = new BigDecimal(0);
		BigDecimal brutto = new BigDecimal(0);

		//int level= Integer.valueOf(OrderHelper.getVal(m, "orderingLevel")).intValue();
		double d_bonus = bonus.doubleValue();

		double d_nettoDist = netto.doubleValue();
		double d_nettoCustomer = netto_customer.doubleValue();
		double d_nettoVipCustomer = netto_vip_customer.doubleValue();

		double d_netto = 0;
		//customer
		if (level == 100) d_netto = d_nettoCustomer;
		//vip customer
		else if (level == 200) d_netto = d_nettoVipCustomer;
		//distributor
		else d_netto = d_nettoDist;
		double tradeMargin = d_netto - d_nettoDist;

		 org.apache.log4j.Logger logger = MainControl.logger;

		 logger.info(" freight tradeMargin: "+tradeMargin+" d_netto: "+d_netto+" d_nettoDist"+d_nettoDist);


		double d_brutto = d_netto + (d_netto * vat.doubleValue())*.01;
		java.text.NumberFormat nf = java.text.NumberFormat.getInstance(Locale.ENGLISH);
		nf.setMinimumFractionDigits(2);
		nf.setMaximumFractionDigits(2);
		nf.setGroupingUsed(false);

		Map orders = (Map)session.getAttribute(prefix+"new_abo_details");
		int count = 0;
		orders.clear();

		Map newRow = new HashMap();
	   newRow.put("netto", new String[] {nf.format(d_netto)});
	   newRow.put("brutto", new String[] {nf.format(d_brutto)});
	   newRow.put("bonus", new String[] {nf.format(d_bonus)});
	   newRow.put("trade_margin", new String[] {nf.format(tradeMargin)});
	   newRow.put("art_id", new String[] {id});
	   newRow.put("art_name", new String[] {descr});
	   newRow.put("art_position", new String[] {String.valueOf(count)});
	   newRow.put("comment", new String[] {""});
	   newRow.put("quantity", new String[] {String.valueOf("1")});
	   newRow.put("list", new String[] {nf.format(d_nettoDist)});
	   newRow.put("vat_value", new String[] {nf.format(vat)});
	   newRow.put("subscription", new String[] {"yes"});

	   orders.put(String.valueOf(count), newRow);

	   orders.put("count", new Integer(count+1));

	}

    public static String getAccountId(String type, String distr_id, Connection c) throws Exception {
		PersistableObject po = new PersistableObject("distributor", new String[] {"id"});
		po.set("id", new Integer(distr_id));
		po.load(c);

		List l = type.equals("bank")?OrderHelper.getBankAccounts(po, c):OrderHelper.getCreditCards(po, c);

		String ret = "";
		
		for (int i=0; i<l.size(); i++) {
			String selected = "";

			PersistableObject p = (PersistableObject)l.get(i);

			boolean def = false;
			if (p.get("default_bill")!=null) {
				Boolean b = (Boolean)p.get("default_bill");
				if (b!=null)
					def = b.booleanValue();
			}
			
			
			
			String value = p.getString("id", "");

			String number = type.equals("bank")?"account_number":"cc_number";

			if (def || i == 0) ret = value;
		}
		
		return ret;
		
    }
    
    public static String addAbo(HttpSession session, Logger logger, String prefix, boolean promo)  throws Exception {

    	
    	 Transaction tx = null;
    	 Exception lastException = null;
    	 for (int j=0; j<3; j++) {
    	   try {
    	       org.hibernate.Session hibernateSession = HibernateUtil.currentSession();
    	       tx= hibernateSession.beginTransaction();
    	       Connection conn = hibernateSession.connection();
    		     boolean admin = false;
    			boolean distributor = false;
    			boolean customer = false;
    			boolean specialAgent = false;
    			if	(session.getAttribute("admin")!=null) admin = true;
    			if	(session.getAttribute("customer")!=null) customer = true;
    			if	(session.getAttribute("distributor")!=null) distributor = true;
    			if  (session.getAttribute("specialAgent")!=null) specialAgent = true;
    			//order header
    			Map jspMap = (Map)session.getAttribute(prefix+"new_abo.jsp");
    			logger.info("ok");

    			String totalBrutto = ((String[])jspMap.get("total_brutto"))[0];

    			double tb = 0;

    			try {
    				tb = Double.parseDouble(totalBrutto);
    			} catch (Exception ex) {
    				throw new EvolutionException("Total Brutto value is wrong: "+totalBrutto);
    			}

    			if (tb < 0) {
    				session.setAttribute(prefix+"new_abo_error", "Total Brutto < 0");
    				if (tx!=null)
    	    	        tx.rollback();
    	    	    HibernateUtil.closeSession();
    				return "";
    			}

    			jspMap.put("created_by", new String[] {(String)session.getAttribute("USER_LOGGED_ID")});
    	logger.info("ok");
    			java.sql.Date thisDate = new java.sql.Date(System.currentTimeMillis());
    	logger.info("ok");
    			jspMap.put("creation_date", new String[] {FormHelper.formatSQLDate(thisDate)});
    	logger.info("ok");

    			//jspMap.put("order_status_id", new String[] {"10"});
    			jspMap.put("store_descr", new String[] {"Villach"});

    			String otStr = ((String[]) jspMap.get("duration"))[0];
    			String diStr = ((String[]) jspMap.get("delivery_intervall"))[0];
    			int otime=0; int di =0;
    			try {
    			   otime=Integer.parseInt(otStr);
    			   if (otime>12 || otime<=0) throw new Exception("");
    			} catch (Exception ex) {
    			    session.setAttribute(prefix+"new_abo_error", "Bitte eine Zahl zw. 1 und 12 eingeben");
 			       if (tx!=null)
      	    	         tx.rollback();
      	    	       HibernateUtil.closeSession();
      	    	       return "";
    			}
    			 
    			Calendar startDate = null;
    			try {
      			  	DateFormat d = DateFormat.getDateInstance(DateFormat.MEDIUM, Locale.GERMAN);
      			  	java.util.Date date = d.parse(((String[]) jspMap.get("start_date"))[0]);
      			  	startDate = Calendar.getInstance();
      			  	startDate.setTime(date);
      			    Calendar n = Calendar.getInstance();
	  			    n.set(Calendar.DATE, -1);
	  			   
	  			    if (startDate.before(n))
	  			    	throw new Exception("Beginndatum muss grsser als heute sein");
      			  	
      			 } catch (Exception ex) {
       			     if (ex instanceof ParseException)
       			    	 session.setAttribute(prefix+"new_abo_error", "ungltiges Format des Beginndatums");
       			     else
       			    	session.setAttribute(prefix+"new_abo_error", ex.getMessage());
    			       if (tx!=null)
         	    	         tx.rollback();
         	    	       HibernateUtil.closeSession();
         	    	       return "";
       			}
      			 
    			try {
    			  di = Integer.parseInt(diStr);
    			 } catch (Exception ex) {
     			    session.setAttribute(prefix+"new_abo_error", "Bitte eine Zahl eingeben");
  			       if (tx!=null)
       	    	         tx.rollback();
       	    	       HibernateUtil.closeSession();
       	    	       return "";
     			}

    			   if (di<=0) {
    			       session.setAttribute(prefix+"new_abo_error", "Lieferintervall<=0");
    			       if (tx!=null)
         	    	         tx.rollback();
         	    	       HibernateUtil.closeSession();
         	    	       return "";

    			   }

    			   if (otime % di !=0) {
    			       session.setAttribute(prefix+"new_abo_error", "Laufzeit muss durch das Lieferintervall teilbar sein");
    			       if (tx!=null)
         	    	         tx.rollback();
         	    	       HibernateUtil.closeSession();
         	    	       return "";
    			   }
    			   
    			  

    		/*	int startMonth = 0;
    			try {
    			    startMonth = Integer.valueOf(((String[]) jspMap.get("start_month"))[0]).intValue();
    			    if (startMonth<1 || startMonth>12) throw new Exception("Invalid value");

    			} catch(Exception e) {
    			   session.setAttribute(prefix+"new_abo_error", "der Wert von Beginnmonat muss zwischen 1 und 12 liegen");
    			   if (tx!=null)
   	    	         tx.rollback();
   	    	       HibernateUtil.closeSession();
   	    	       return "";
    			} */

    			jspMap.put("max_delivery", new String[]{String.valueOf(otime/di)});
    			jspMap.put("delivered","0");
    			java.sql.Date nextDelivery= 
    					getNextDelivery(new java.sql.Date(startDate.getTime().getTime()), 
    							Integer.valueOf(((String[]) jspMap.get("operating_time"))[0]).intValue());
    			jspMap.put("next_delivery", new String[] {FormHelper.formatSQLDate(nextDelivery)});
    			//jspMap.put("start_time", new String[] {FormHelper.formatSQLDate(thisDate)});
    			String ot = "3";

    			if (distributor) ot = "2";

    			//jspMap.put("order_type", new String[] {ot});


    			String pay_method_id = ((String[])jspMap.get("pay_method_id"))[0];
    			if ("1".equals(pay_method_id) || "2".equals(pay_method_id)) {
    				String acc_id = "";
    				
    				if (promo) {
    					String distr_id = ((String[])jspMap.get("distr_id"))[0];
    					String type = "";
    					if ("1".equals(pay_method_id))
    						type = "bank";
    					else type = "cc";
    					 
    					
    					acc_id = getAccountId(type, distr_id, conn);
    				} else {
        				if ("1".equals(pay_method_id))
        					acc_id = ((String[])jspMap.get("account_id_1"))[0];
        				if ("2".equals(pay_method_id))
        					acc_id = ((String[])jspMap.get("account_id_2"))[0];
    				}
    				
    				jspMap.put("account_id", new String[] {acc_id});
    			}

    			/*if (!"3".equals(pay_method_id) && !"4".equals(pay_method_id)) {
    				jspMap.put("bonus_date", new String[] {FormHelper.formatSQLDate(thisDate)});
    			}*/


    			PersistableObject po = new PersistableObject("payment_method", "id");
    			po.set("id", new Integer(pay_method_id));
    	logger.info("ok");
    			try {
    				po.load(conn);
    				jspMap.put("pay_method_descr", new String[] {po.getString("descr", "")});
    			} catch (Exception e) {
    				logger.info("WARNING: payment description cannot be loaded: id: "+pay_method_id);
    			}


    	

    			SuperPO spo = new SuperPO("subscription_header", logger);
    	
    			spo.addMap(jspMap);
    
    			spo.insert(conn);
    
    			ObjectSearch last = new ObjectSearch();
    			List l = last.search(conn,"select {fn currval('seq_subscription_header')}");
    			PersistableObject currvalRow = (PersistableObject) l.get(0);
    			logger.info(currvalRow.get("currval").getClass());
    			Long  newid = (Long) currvalRow.get("currval");
    	logger.info("ok");
    			String orderid = String.valueOf(newid);

    	logger.info("ok");
    			//order details
    			Map orders = (Map)session.getAttribute(prefix+"new_abo_details");

    			int count = 0;

    			try {
    				count = ((Integer)orders.get("count")).intValue();
    			} catch (Exception e) {
    				logger.info("WARNING: count cannot be achieved from subscription_details");

    				throw new EvolutionException("Inconsistence error, login again!");
    			}

    			for (int i = 0; i<count; i++) {
    				SuperPO act = new SuperPO("subscription_detail", logger);
    				Map a = (Map)orders.get(String.valueOf(i));
    				if (a==null) continue;
    				act.addMap(a);
    				act.setColumn("subscr_id", orderid);
    				act.setColumn("art_position", String.valueOf(i));
    				String[] sa = (String[]) a.get("subscription");
    				if (sa==null || sa.length==0 || sa[0]==null || sa[0].equals(""))
    					act.setPOColumn("subscription", new Boolean(false));
    				else
    					act.setPOColumn("subscription", new Boolean(true));

    				act.insert(conn);
    			}
    			tx.commit();
    			/*try {
    			    if (thisDate.equals(nextDelivery)) AboChecker.createOrderFromAbo(hibernateSession,newid);
    			} catch (Exception e) {
    			    logger.error("Error when creating order from abo", e);
    			}*/
    			HibernateUtil.closeSession();
    			return orderid;
    	   } catch (Exception ex) {
    	       lastException =ex;


    	       try {
    	           if (tx!=null)
    	            tx.rollback();
    	        HibernateUtil.closeSession();
    	       } catch (Exception e) {}
    	       if (ex instanceof EvolutionException) throw ex;
    	       logger.error("Error occuring when creating the order",ex);
    		    if (j<2) logger.info("Trying to fix it, executing it one more time");


    	   }
    	 }

    	 throw lastException;
    	}

    private static java.sql.Date changeNextDelivery(java.sql.Date nextDelivery, int operatingTime) {
        int[] otimes = new int[]{0,1,8,16,24};
        Calendar now = Calendar.getInstance();
        int currentDay = now.get(Calendar.DATE);
        Calendar newNextDelivery = Calendar.getInstance();
        newNextDelivery.setTime(nextDelivery);
       // int nextDeliveryDay = newNextDelivery.get(Calendar.DATE);
        newNextDelivery.set(Calendar.DATE,1);
        if (now.before(newNextDelivery))
            newNextDelivery.set(Calendar.DATE, otimes[operatingTime]);
        else {
            if (currentDay<otimes[operatingTime]) {
                newNextDelivery.set(Calendar.DATE, otimes[operatingTime]);
            } else if (operatingTime<otimes.length-1 && currentDay>=otimes[operatingTime+1]) {
                newNextDelivery.set(Calendar.DATE, otimes[operatingTime]);
                newNextDelivery.add(Calendar.MONTH,1);
            } else {
                newNextDelivery.set(Calendar.DATE, currentDay);
            }

        }

        return new java.sql.Date(newNextDelivery.getTimeInMillis());

    }


//    private static Calendar toCalendarForThisYear(int startMonth, int operatingTime) {
//        int[] otimes = new int[]{0,1,8,16,24};
//        Calendar cal = Calendar.getInstance();
//        int currentDay = cal.get(Calendar.DATE);
//        int currentMonth = cal.get(Calendar.MONTH)+1;
//        cal.set(Calendar.MONTH, startMonth-1);
//
//        if (startMonth!=currentMonth ||
//                (startMonth==currentMonth && 
//                (currentDay<otimes[operatingTime] || 
//                		(operatingTime<otimes.length-1 && currentDay>=otimes[operatingTime+1]))))
//            cal.set(Calendar.DATE, otimes[operatingTime]);
//
//
//        return cal;
//    }


//    private static java.sql.Date getNextDelivery(java.sql.Date creationDate,int startMonth, int operatingTime) {
//
//        Calendar cal = Calendar.getInstance();
//        cal.setTime(creationDate);
//        Calendar temp = toCalendarForThisYear(startMonth, operatingTime);
//        if (temp.before(cal)) temp.add(Calendar.YEAR,1);
//        return new java.sql.Date(temp.getTimeInMillis());
//
//    }
    
    private static java.sql.Date getNextDelivery(java.sql.Date startDate, int operatingTime) {
    	int[] otimes = new int[]{0,1,8,16,24};
    	Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        
        int startDay = cal.get(Calendar.DATE);
        int startMonth = cal.get(Calendar.MONTH);
        //cal.set(Calendar.MONTH, startMonth-1);
        Calendar now = Calendar.getInstance();
        
        if (startDay<otimes[operatingTime])
            cal.set(Calendar.DATE, otimes[operatingTime]);
        else if (operatingTime<otimes.length-1 && startDay>=otimes[operatingTime+1]) {
        	cal.set(Calendar.DATE, otimes[operatingTime]);
        	cal.add(Calendar.MONTH,1);
        }

       
        return new java.sql.Date(cal.getTimeInMillis());
    }
    
   


    public static String getPaymentOptions(HttpSession session, String whichMap) throws Exception {
		PM[] ss ;

		Map jsp = (Map)session.getAttribute(whichMap);

		String pay_method_id = (jsp.get("pay_method_id")!=null)?
		((String[])jsp.get("pay_method_id"))[0]:"";

		boolean slip_selected = pay_method_id.equals("6");		
		
		if (jsp.get("payment_slip")!=null) {
			Boolean ps = (Boolean)jsp.get("payment_slip");
			if (ps.booleanValue())
				ss = FormHelper.getPMsAll();
			else {
				if (!slip_selected)
					ss = FormHelper.getPMs();
				else ss = FormHelper.getPMsAll();
			}
		}
		else {
			if (!slip_selected)
				ss = FormHelper.getPMs();
			else ss = FormHelper.getPMsAll();
		}		
		
		
		StringBuffer sb = new StringBuffer();

		for (int i = 0; i<ss.length; i++) {
			PM s = ss[i];
			String selected = pay_method_id.equalsIgnoreCase(s.id)?" selected":"";

			boolean append = true;

			if (s.id.equals("1")) {
				if (getAccountOptions(session, whichMap, "bank").equals("")) append = false;
			}
			else if (s.id.equals("2")) {
				if (getAccountOptions(session, whichMap, "creditcard").equals("")) append = false;
			}
			if (append)
				sb.append("<option"+ selected +" value=\"" + s.id + "\">"+s.value+"</option>");
		}
		return sb.toString();
	}


    public static void logMap(Logger logger, String name, Map map) {

     logger.info("Logging map "+name);
     if (map==null) {
         logger.info("Map is null");
         return;
     }
     Iterator it = map.keySet().iterator();
     while (it.hasNext()) {
         Object key = it.next();
         Object value = map.get(key);
         logger.info(key+" = "+ value);
     }

    }
    public static String getAccountOptions(HttpSession session, String whichMap, String type) throws Exception{
		PersistableObject po = new PersistableObject("distributor", new String[] {"id"});
		Logger logger = MainControl.logger;
		logger.info("whichMap: "+whichMap);
		Map m = (Map)session.getAttribute(whichMap);

		String id = ((String[])m.get("distr_id"))[0];

		po.set("id", new Integer(id));

		po.load();

		List l = type.equals("bank")?OrderHelper.getBankAccounts(po):OrderHelper.getCreditCards(po);

		StringBuffer sb = new StringBuffer();

		boolean toCode = true;


		for (int i=0; i<l.size(); i++) {
			String selected = "";

			PersistableObject p = (PersistableObject)l.get(i);

			boolean def = false;
			if (p.get("default_bill")!=null) {
				Boolean b = (Boolean)p.get("default_bill");
				if (b!=null)
					def = b.booleanValue();
			}
			
			if (def) selected = " selected";
			
			String value = p.getString("id", "");

			String number = type.equals("bank")?"account_number":"cc_number";

			String screen = toCode?OrderHelper.decodeCardNumber(p.getString(number, ""), 4):p.getString(number, "");

			sb.append("<option"+selected+" value=\""+value+"\">"+screen+"</option>");
		}

		return sb.toString();
	}

    public static Map getOrderPerson(String distr_id) throws Exception {
		Map m = new HashMap();

		PersistableObject po = new PersistableObject("distributor", new String[] {"id"});

		po.set("id", new Integer(distr_id));

		po.load();

		List addresses = OrderHelper.getAddresses(po);

		m.put("distr_type", new String[] {OrderHelper.getLevel(po)});

		Boolean ps = (Boolean)po.get("payment_slip");
		if (ps!=null)
			m.put("payment_slip", ps);		
		
		m.put("sponsor", new String[] {po.getString("sponsor", "n/a")});
		m.put("tel", new String[] {OrderHelper.generateTels(po)});
		m.put("orderingCountry", new String[] {po.getString("country_code", "")});
		m.put("orderingLevelId", new String[] {po.getString("level_id", "100")});
		m.put("UID", new String[] {po.getString("vat_id", "")});
		
		for (int i = 0; i<addresses.size(); i++) {

			PersistableObject address = (PersistableObject)addresses.get(i);
			
			Boolean def_bill = (Boolean)address.get("default_bill");

			if (def_bill.booleanValue()) {
				m.put("billing_postcode", new String[] {address.getString("postcode", "")});
				m.put("billing_city", new String[] {address.getString("city", "")});
				m.put("billing_street", new String[] {address.getString("street", "")});
				m.put("billing_country_id", new String[] {address.getString("country_post_code", "")});
				String delivery_name = address.getString("delivery_name", "");
				if (!delivery_name.equals(""))
					m.put("billing_name", new String[] {delivery_name});
			}
		}

		if (m.get("billing_name")==null || m.get("billing_name").equals("")) {
			m.put("billing_name", new String[]
			  {OrderHelper.getTitle(po)+po.getString("firstname", "")+" "+po.getString("lastname", "")});
			m.put("billing_title", new String[] {OrderHelper.getLevelAddress(po)});
		}

		
		return m;

	}
    
    
    public static void loadAbo( HttpSession session, String aboID, String jsp, String prefix) throws Exception {
    	//already checked
    	int id = Integer.parseInt(aboID);

    	ObjectSearch os = new ObjectSearch("subscription_header", new String[] {"id"});
    	os.setCondition("id = ?");
    	List result = os.search(new Object[] {new Long(id)});

    	//already checked
    	PersistableObject po = (PersistableObject)result.get(0);

    	SuperPO spo = new SuperPO("subscription_header", MainControl.logger);

    	spo.setMain(po.getValues());

    	Map jspMap = new HashMap();

    	java.sql.Date startDate = (java.sql.Date)spo.getPOColumn("start_date");
    	
    	jspMap.putAll(spo.getTextMap());

    	jspMap.putAll(getOrderPerson((String)spo.getColumn("distr_id")));
    	

    //	boolean canmod = false;

    /*	if (spo.getColumn("order_status_id").equals("10") || spo.getColumn("order_status_id").equals("20"))
    		canmod = true;

    	if (canmod)
    		jspMap.put("canmod", new String[] {"yes"});
    	else
    		jspMap.put("canmod", new String[] {"no"}); */

    	session.setAttribute(prefix+jsp, jspMap);

    	ObjectSearch os2 = new ObjectSearch("subscription_detail", new String[] {"id"});
    	
    	os2.setCondition("subscr_id = ?");
    	os2.setOrderBy(new String[] {"art_position"});
    	List details = os2.search(new Object[] {new Long(aboID)});

    	Map detailsMap = (Map)session.getAttribute(prefix+"abo_details");
    	if (detailsMap!=null) detailsMap.clear();
    	
    	String olid = "400";
    	String[] kkk = (String[])jspMap.get("orderingLevelId");
    	if (kkk != null && kkk.length>0) {
    		olid = kkk[0];
    		detailsMap.put("ordering_level_id", kkk[0]);
    	}
    	
    	OrderHelper.setDetails(session, details, prefix+"abo_details", "subscription_detail", startDate, olid);
    }

    public static String generateOrderDetailsHeader(PageContext pc, String from) throws Exception {
		HttpSession session = pc.getSession();

		boolean customer_order = false;
		
		Map orders = (Map)session.getAttribute(from);
		String level_id = (String)orders.get("ordering_level_id");
		if ("100".equals(level_id) || "130".equals(level_id) || "160".equals(level_id) || "200".equals(level_id))
			customer_order = true;
		
		boolean admin = false;
		boolean distributor = false;
		boolean customer = false;
		if	(session.getAttribute("admin")!=null) admin = true;
		if	(session.getAttribute("customer")!=null) customer = true;
		if	(session.getAttribute("distributor")!=null) distributor = true;

		StringBuffer sb = new StringBuffer();
		sb.append("<table id=\"dataTable\" width=\"890\">");
		
		if (distributor) {
			sb.append("<col width=\"30\"><col width=\"70\"><col width=\"270\"><col width=\"60\">" +
					"<col width=\"60\"><col width=\"60\"><col width=\"60\"><col width=\"60\">"+
			"<col width=\"70\"><col width=\"150\">");
			sb.append("<tr id=\"dataTableHeaderContent\">");
			sb.append("<td>L</td><td>ArtId</td><td>"+LocaleSupport.getLocalizedMessage(pc, "ART_NAME")+"</td><td>"+LocaleSupport.getLocalizedMessage(pc, "PIECE")+"</td>"+
					"<td>"+LocaleSupport.getLocalizedMessage(pc, "SUBSCRIPTION_INCL")+"</td>"+	
			"<td>"+LocaleSupport.getLocalizedMessage(pc, "NETTO")+"</td><td>"+LocaleSupport.getLocalizedMessage(pc, "VAT_PERC")+"</td><td>"+LocaleSupport.getLocalizedMessage(pc, "BRUTTO")+"</td>"+
			"<td>"+LocaleSupport.getLocalizedMessage(pc, "BONUSW")+"</td><td>"+LocaleSupport.getLocalizedMessage(pc, "COMMENT")+"</td>");
			sb.append("</tr>");
		}
		else if (admin) {
			if (customer_order) {
				sb.append("<col width=\"30\"><col width=\"70\"><col width=\"280\"><col width=\"60\">" +
						"<col width=\"60\"><col width=\"60\"><col width=\"60\"><col width=\"60\"><col width=\"60\">" +
						"<col width=\"150\">");
						sb.append("<tr id=\"dataTableHeaderContent\">");
						sb.append("<td>L</td><td>ArtId</td><td>"+LocaleSupport.getLocalizedMessage(pc, "ART_NAME")+"</td><td>"+LocaleSupport.getLocalizedMessage(pc, "INVENTORY")+"</td>"+"<td>"+LocaleSupport.getLocalizedMessage(pc, "PIECE")+"</td>"+
						"<td>"+LocaleSupport.getLocalizedMessage(pc, "SUBSCRIPTION_INCL")+"</td>"+	
						"<td>"+LocaleSupport.getLocalizedMessage(pc, "NETTO")+"</td><td>"+LocaleSupport.getLocalizedMessage(pc, "VAT_PERC")+"</td><td>"+LocaleSupport.getLocalizedMessage(pc, "BRUTTO")+"</td>"+
						"<td>"+LocaleSupport.getLocalizedMessage(pc, "COMMENT")+"</td>");
						sb.append("</tr>");
			} else {
				sb.append("<col width=\"30\"><col width=\"70\"><col width=\"210\"><col width=\"60\">" +
						"<col width=\"60\"><col width=\"60\"><col width=\"60\"><col width=\"60\"><col width=\"60\">" +
						"<col width=\"70\"><col width=\"150\">");
						sb.append("<tr id=\"dataTableHeaderContent\">");
						sb.append("<td>L</td><td>ArtId</td><td>"+LocaleSupport.getLocalizedMessage(pc, "ART_NAME")+"</td><td>"+LocaleSupport.getLocalizedMessage(pc, "INVENTORY")+"</td>"+"<td>"+LocaleSupport.getLocalizedMessage(pc, "PIECE")+"</td>"+
						"<td>"+LocaleSupport.getLocalizedMessage(pc, "SUBSCRIPTION_INCL")+"</td>"+	
						"<td>"+LocaleSupport.getLocalizedMessage(pc, "NETTO")+"</td><td>"+LocaleSupport.getLocalizedMessage(pc, "VAT_PERC")+"</td><td>"+LocaleSupport.getLocalizedMessage(pc, "BRUTTO")+"</td>"+
						"<td>"+LocaleSupport.getLocalizedMessage(pc, "BONUSW")+"</td>"+
						"<td>"+LocaleSupport.getLocalizedMessage(pc, "COMMENT")+"</td>");
						sb.append("</tr>");
			}
		}		
/*		if (admin || distributor) {
			sb.append("<col width=\"30\"><col width=\"70\"><col width=\"230\"><col width=\"60\">"+
					"<col width=\"40\">" +
					"<col width=\"60\"><col width=\"60\"><col width=\"60\">"+
			"<col width=\"60\"><col width=\"70\"><col width=\"150\">");
			sb.append("<tr id=\"dataTableHeaderContent\">");
			sb.append("<td>L</td><td>ArtId</td><td>"+LocaleSupport.getLocalizedMessage(pc, "ART_NAME")+"</td><td>"+LocaleSupport.getLocalizedMessage(pc, "PIECE")+"</td>"+
			"<td>"+LocaleSupport.getLocalizedMessage(pc, "SUBSCRIPTION_INCL")+"</td>"+		
			"<td>"+LocaleSupport.getLocalizedMessage(pc, "NETTO")+"</td><td>"+LocaleSupport.getLocalizedMessage(pc, "BRUTTO")+"</td><td>"+LocaleSupport.getLocalizedMessage(pc, "VAT_PERC")+"</td>"+
			"<td>"+LocaleSupport.getLocalizedMessage(pc, "POINT")+"</td><td>"+LocaleSupport.getLocalizedMessage(pc, "BONUSW")+"</td><td>"+LocaleSupport.getLocalizedMessage(pc, "COMMENT")+"</td>");
			sb.append("</tr>");
		}*/
		else if (customer) {
			sb.append("<col width=\"30\"><col width=\"70\"><col width=\"230\"><col width=\"60\">"+
			"<col width=\"60\"><col width=\"60\"><col width=\"340\">");
			sb.append("<tr id=\"dataTableHeaderContent\">");
			sb.append("<td>"+LocaleSupport.getLocalizedMessage(pc, "L")+"</td><td>"+LocaleSupport.getLocalizedMessage(pc, "ART_ID")+"</td><td>"+LocaleSupport.getLocalizedMessage(pc, "ART_NAME")+"</td><td>"+LocaleSupport.getLocalizedMessage(pc, "PIECE")+"</td>"+
					"<td>"+LocaleSupport.getLocalizedMessage(pc, "SUBSCRIPTION_INCL")+"</td>"+		
			"<td>"+LocaleSupport.getLocalizedMessage(pc, "BRUTTO")+"</td><td>"+LocaleSupport.getLocalizedMessage(pc, "VAT_PERC")+"</td><td>"+LocaleSupport.getLocalizedMessage(pc, "COMMENT")+"</td>");
			sb.append("</tr>");
		}
		//sb.append(level_id).append(from);
		return sb.toString();
	}

	public static String generateOrderTotalRow(PageContext pc, String from) throws Exception {

		HttpSession session = pc.getSession();

		boolean customer_order = false;
		Map orders = (Map)session.getAttribute(from);
		String level_id = (String)orders.get("ordering_level_id");
		if ("100".equals(level_id) || "130".equals(level_id) || "160".equals(level_id) || "200".equals(level_id))
			customer_order = true;
		
		boolean admin = false;
		boolean distributor = false;
		boolean customer = false;
		if	(session.getAttribute("admin")!=null) admin = true;
		if	(session.getAttribute("customer")!=null) customer = true;
		if	(session.getAttribute("distributor")!=null) distributor = true;
		boolean dealer = false;
		if ("t".equals(session.getAttribute("USER_LOGGED_TYPE"))) {
			dealer = true;
			distributor = false;
		}
		
		String totalNetto = "";
		String totalBrutto = "";
		String totalBonus = "";
		String totalTradeMargin = "";

		String[] values = countTotals(session, from, false);
		totalNetto = values[0];
		totalBrutto = values[1];
		totalBonus = values[2];
		totalTradeMargin = values[3];

		StringBuffer sb = new StringBuffer();
		sb.append("<table id=\"dataTable\" style=\"table-layout:fixed; font-size:12px;\" width=\"840\">");
		if (distributor) {
			sb.append("<col width=\"30\"><col width=\"70\"><col width=\"270\"><col width=\"60\">" +
					"<col width=\"60\"><col width=\"60\"><col width=\"60\"><col width=\"60\">"+
			"<col width=\"70\"><col width=\"150\">");
			sb.append("<tr style=\"padding-left: 0px;padding-right: 0px;\"><td colspan=\"2\">"+LocaleSupport.getLocalizedMessage(pc, "TOTAL")+":</td>" +
					"<td>&nbsp;</td><td>&nbsp;</td>"+
					"<td>&nbsp;</td>"+
			"<td style=\"text-align: right;\">"+ totalNetto + "</td>"+
			"<td style=\"text-align: right;\">"+ totalBrutto + "</td>"+
			"<td>&nbsp;</td>"+
			"<td style=\"text-align: right;\">"+ totalBonus + "</td><td>&nbsp;</td></tr>");
		} else if (admin) {
			if (customer_order) {
				sb.append("<col width=\"30\"><col width=\"70\"><col width=\"280\"><col width=\"60\">" +
						"<col width=\"60\"><col width=\"60\"><col width=\"60\"><col width=\"60\"><col width=\"60\">" +
						"<col width=\"150\">");
				sb.append("<tr style=\"padding-left: 0px;padding-right: 0px;\">" +
						"<td colspan=\"2\">"+LocaleSupport.getLocalizedMessage(pc, "TOTAL")+":</td>" +
								"<td colspan=\"2\">&nbsp;</td><td>&nbsp;</td>"+
				"<td style=\"text-align: right;\">"+ totalNetto + "</td>"+
				"<td>&nbsp;</td>"+
				"<td style=\"text-align: right;\">"+ totalBrutto + "</td>"+
				"<td>&nbsp;</td>"+
				"<td>&nbsp;</td></tr>");				
			} else {
				sb.append("<col width=\"30\"><col width=\"70\"><col width=\"210\"><col width=\"60\">" +
						"<col width=\"60\"><col width=\"60\"><col width=\"60\"><col width=\"60\"><col width=\"60\">" +
						"<col width=\"70\"><col width=\"150\">");
				sb.append("<tr style=\"padding-left: 0px;padding-right: 0px;\">" +
						"<td colspan=\"2\">"+LocaleSupport.getLocalizedMessage(pc, "TOTAL")+":</td>" +
								"<td colspan=\"2\">&nbsp;</td><td>&nbsp;</td>"+
						"<td>&nbsp;</td>"+
				"<td style=\"text-align: right;\">"+ totalNetto + "</td>"+
				"<td style=\"text-align: right;\">"+ totalBrutto + "</td>"+
				"<td>&nbsp;</td>"+
				"<td style=\"text-align: right;\">"+ totalBonus + "</td>"+
				"<td>&nbsp;</td></tr>");
			}
		}
		else if (customer) {
			sb.append("<col width=\"30\"><col width=\"70\"><col width=\"230\"><col width=\"60\">"+
					"<col width=\"40\">"+
			"<col width=\"60\"><col width=\"60\"><col width=\"340\">");
			sb.append("<tr><td colspan=\"2\">"+LocaleSupport.getLocalizedMessage(pc, "TOTAL")+":</td><td>&nbsp;</td><td>&nbsp;</td>"+
					"<td>&nbsp;</td>"+
			"<td style=\"text-align: right;\">"+ totalBrutto + "</td>"+
			"<td>&nbsp;</td><td>&nbsp;</td></tr>");
		} else if (dealer) {
			sb.append("<col width=\"30\"><col width=\"70\"><col width=\"300\"><col width=\"80\">"+
					"<col width=\"40\">"+
			"<col width=\"80\"><col width=\"70\"><col width=\"70\"><col width=\"150\">");
			sb.append("<tr><td colspan=\"2\">"+LocaleSupport.getLocalizedMessage(pc, "TOTAL")+":</td><td>&nbsp;</td><td>&nbsp;</td>"+
					"<td>&nbsp;</td>"+
					"<td style=\"text-align: right;\">"+ totalNetto + "</td>"+
			"<td style=\"text-align: right;\">"+ totalBrutto + "</td>"+
			"<td>&nbsp;</td><td>&nbsp;</td></tr>");
			
		}

		sb.append("</table>");


			sb.append("<input type=\"hidden\" name=\"total_netto\" value=\""+ totalNetto+"\">");
			sb.append("<input type=\"hidden\" name=\"total_bonus\" value=\""+ totalBonus+"\">");
			sb.append("<input type=\"hidden\" name=\"total_trade_margin\" value=\""+ totalTradeMargin+"\">");

			sb.append("<input type=\"hidden\" name=\"total_brutto\" value=\""+ totalBrutto+"\">");


		return sb.toString();
	}    
    
	public static String[] countTotals(HttpSession session, String from, boolean discount_count) throws Exception {
		Map m = (Map)session.getAttribute(from);
		
		String level_id = (String)m.get("ordering_level_id");
		
		String netto = "";
		String brutto = "";
		String bonus = "";
		String trade = "";

		int count = 0;

		if (m.get("count")!=null)
			count = ((Integer)m.get("count")).intValue();

		double n = 0;
		BigDecimal br = new BigDecimal(0);
		double p = 0;
		double bo = 0;
		double t = 0;
		
		for (int i = 0; i<count; i++) {

			Map actual = (Map)m.get(String.valueOf(i));
			if (actual == null) continue;

			int q = 0;

			String quantity = ((String[])actual.get("quantity"))[0];

			try {
				q = Integer.parseInt(quantity);
			} catch (Exception e) {
				q = 0;
			}

			String ns = ((String[])actual.get("netto"))[0];
			String brs = ((String[])actual.get("brutto"))[0];
			String bos = ((String[])actual.get("bonus"))[0];
			String ts = ((String[])actual.get("trade_margin"))[0];

			double dnetto = Double.parseDouble(ns);
			BigDecimal dbrutto = new BigDecimal(brs);
			double dbonus = Double.parseDouble(bos);
			double dtrade = Double.parseDouble(ts);

			n = n+dnetto*q;
			br = br.add(dbrutto.multiply(new BigDecimal(q)));
			bo = bo+dbonus*q;
			t = t+dtrade*q;
		}

		java.text.NumberFormat nf = java.text.NumberFormat.getInstance(Locale.ENGLISH);
		nf.setMinimumFractionDigits(2);
		nf.setMaximumFractionDigits(2);
		nf.setGroupingUsed(false);


		netto=nf.format(n);
		brutto = nf.format(br);
		bonus = nf.format(bo);
		trade = nf.format(t);
		
		return new String[] {netto, brutto, bonus, trade};
	}

	
    public static boolean modifyAbo(HttpSession session, Logger logger, String prefix) throws Exception {
		Map jspMap = (Map)session.getAttribute(prefix+"abo_detail.jsp");
		logger.info("Using jspmap: "+prefix+"abo_detail.jsp");
		String totalBrutto = ((String[])jspMap.get("total_brutto"))[0];
		logger.info("payment_method: "+((String[])jspMap.get("pay_method_id"))[0]);
		logger.info("account_id_1: " + jspMap.get("account_id_1"));
		logger.info("account_id_2: " + jspMap.get("account_id_2"));
		Transaction tx = null;
		try {
			double tb = 0;
			Session hibernateSession = HibernateUtil.currentSession();
			tx= hibernateSession.beginTransaction();
			Connection conn = hibernateSession.connection();

			try {

				tb = Double.parseDouble(totalBrutto);
			} catch (Exception ex) {
				throw new EvolutionException("Total Brutto value is wrong: "+totalBrutto);
			}

			if (tb < 0) {
				session.setAttribute(prefix+"abo_error", "Total Brutto < 0");
				try {
				    tx.rollback();
				} catch (Exception e) {MainControl.logger.error("Error while rollbacking", e);};
				hibernateSession.close();
				return false;
			}

			String otStr = ((String[]) jspMap.get("duration"))[0];
			int otime=0;
			try {
			   otime=Integer.parseInt(otStr);
			   if (otime>12 || otime<=0) throw new Exception("");
			} catch (Exception ex) {
			    session.setAttribute(prefix+"new_abo_error", "Bitte eine Zahl zw. 1 und 12 eingeben");
			       if (tx!=null)
  	    	         tx.rollback();
  	    	       HibernateUtil.closeSession();
  	    	       return false;
			}



			//order details
			Map aboDetails = (Map)session.getAttribute(prefix+"abo_details");

			int count = 0;

			String aboid = (String)session.getAttribute(prefix+"CURRENT_ABO_ID");

			try {
				count = ((Integer)aboDetails.get("count")).intValue();
			} catch (Exception e) {

				logger.info("WARNING: count cannot be achieved from order_details");
				throw new EvolutionException("Inconsistence error, login again!");
			}

			ObjectSearch os = new ObjectSearch("subscription_detail", new String[] {"id"});

			os.setCondition("subscr_id = ?");

			List toDelete = os.search(conn, new Object[] {new Integer(aboid)});

			for (int z = 0; z<toDelete.size(); z++) {
				PersistableObject del = (PersistableObject)toDelete.get(z);
				logger.info("deleting existing abo detail, art-position: "+del.getString("art_position", "n/a"));
				
				del.delete(conn);
			}

			for (int i = 0; i<count; i++) {
				SuperPO act = new SuperPO("subscription_detail", logger);
				Map a = (Map)aboDetails.get(String.valueOf(i));
				if (a==null) continue;
				act.addMap(a);
				act.setColumn("subscr_id", aboid);
				act.setColumn("art_position", String.valueOf(i));
				String[] sa = (String[]) a.get("subscription");
				if (sa==null || sa.length==0 || sa[0]==null || sa[0].equals(""))
					act.setPOColumn("subscription", new Boolean(false));
				else
					act.setPOColumn("subscription", new Boolean(true));
				
				logger.info("Inserting new ab detail: id: "+act.getColumn("id"));
				
				act.insert(conn);
			}

			//order header


			String pay_method_id = ((String[])jspMap.get("pay_method_id"))[0];
			if ("1".equals(pay_method_id) || "2".equals(pay_method_id)) {
				String acc_id = "";
				if ("1".equals(pay_method_id))
					acc_id = ((String[])jspMap.get("account_id_1"))[0];
				if ("2".equals(pay_method_id))
					acc_id = ((String[])jspMap.get("account_id_2"))[0];
				jspMap.put("account_id", new String[] {acc_id});
			}

			jspMap.put("id", new String[] {aboid});
			jspMap.put("created_by", new String[] {(String)session.getAttribute("USER_LOGGED_ID")});




			PersistableObject po = new PersistableObject("payment_method", "id");
			po.set("id", new Integer(pay_method_id));

			try {
				po.load(conn);

				jspMap.put("pay_method_descr", new String[] {po.getString("descr", "")});


			} catch (Exception e) {
				logger.info("WARNING: payment description cannot be loaded: id: "+pay_method_id);
			}

			SuperPO spo = new SuperPO("subscription_header", logger);

			spo.setColumn("id", (String)session.getAttribute(prefix+"CURRENT_ABO_ID"));
			spo.load(conn);
			String deliveredStr = spo.getColumn("delivered");

			if (!Tools.equals(jspMap, "old_duration" , "duration")) {
			    int duration = Integer.valueOf(OrderHelper.getVal(jspMap, "duration")).intValue();
			    int deliveryIntervall = Integer.valueOf(OrderHelper.getVal(jspMap, "delivery_intervall")).intValue();
			    int delivered = Integer.valueOf(deliveredStr).intValue();


			    try {
			      if (duration % deliveryIntervall!=0)
			          throw new Exception("Laufzeit muss durch das Lieferintervall teilbar sein!");

			      int newMaxDelivery = duration / deliveryIntervall;
			      if (newMaxDelivery<=delivered)
			          throw new Exception("Laufzeit ist zu wenig. Bitte einen höheren Wert eingeben!");

			      jspMap.put("max_delivery", new String[] {Integer.toString(newMaxDelivery)});
			    } catch (Exception e) {
			        session.setAttribute(prefix+"abo_error", e.getMessage());
		  			if (tx!=null)
		 	    	      tx.rollback();
		 	    	 HibernateUtil.closeSession();
		 	    	return false;
			    }

			}
			java.sql.Date nextDelivery = (java.sql.Date) spo.getPOColumn("next_delivery");
			if (jspMap.get("auto_extension")==null)
			    spo.setPOColumn("auto_extension", new Boolean(false));
			 if (nextDelivery == null && jspMap.get("auto_extension")!=null) {
			    logger.info("enabling subscription");
			    nextDelivery = changeNextDelivery(new java.sql.Date(System.currentTimeMillis()), Integer.valueOf(OrderHelper.getVal(jspMap,"operating_time")).intValue());
			    spo.setPOColumn("next_delivery", nextDelivery);
			} else if (nextDelivery==null && jspMap.get("auto_extension")==null) {
			    logger.warn("Do not change subscription when expired and not enabled");

			    session.setAttribute(prefix+"abo_error", "Abo ist schon abgelaufen.");

			}
			//Security: Checking from the database not from the map


			//changing the first next_delivery
			else if (deliveredStr.equals("0")) {
			     java.util.Date startDate = null;
			      try {
			    	  
			    	  DateFormat dateFormat = DateFormat.getDateInstance(DateFormat.MEDIUM, Locale.GERMAN);
	  			    startDate = dateFormat.parse(((String[]) jspMap.get("start_date"))[0]);
	  			  
	  			    if (startDate == null) throw new Exception("der Wert von Beginnmonat muss zwischen 1 und 12 liegen");
	  			    Calendar n = Calendar.getInstance();
	  			    n.add(Calendar.DATE, -1);
	  			    Calendar sd = Calendar.getInstance();
	  			    sd.setTime(startDate);
	  			    if (!Tools.equals(jspMap, "old_start_date", "start_date") && n.after(sd))
	  			    	throw new Exception("Beginndatum muss grsser als heute sein.");
	  			    
	  			   

	  			} catch(Exception e) {
	  			   session.setAttribute(prefix+"abo_error", e.getMessage());
	  			   if (tx!=null)
	 	    	         tx.rollback();
	 	    	       HibernateUtil.closeSession();
	 	    	       return false;
	  			}
			  if ((!Tools.equals(jspMap, "old_operating_time", "operating_time")
			        || !Tools.equals(jspMap, "old_start_date", "start_date"))) {

				   
			    nextDelivery = getNextDelivery(new java.sql.Date(startDate.getTime()),
			            Integer.valueOf(OrderHelper.getVal(jspMap, "operating_time")).intValue());

			    spo.setPOColumn("next_delivery", nextDelivery);
			  }
			} else {
			    if (!Tools.equals(jspMap, "old_operating_time", "operating_time"))
			        nextDelivery= changeNextDelivery(nextDelivery, Integer.valueOf(OrderHelper.getVal(jspMap,"operating_time")).intValue());
			    spo.setPOColumn("next_delivery", nextDelivery);
			}

			spo.addMap(jspMap);

			Map rv = spo.getMain();

			/*if (!"3".equals(pay_method_id) && !"4".equals(pay_method_id)) {

				java.sql.Date od = (java.sql.Date)rv.get("order_date");
				logger.info("date: "+od);
				rv.put("bonus_date", od);

			} else {
				rv.put("bonus_date", null);
			}*/


			spo.update(conn);
			tx.commit();
			HibernateUtil.closeSession();
			return true;
		} catch (Exception ex) {
		    logger.error("Error modifying abo ",ex);
		    logger.info("rolling back");
		    try {
			    if (tx!=null)
			        tx.rollback();
			    HibernateUtil.closeSession();
		    } catch (Exception e) {}
		    throw ex;
		}
	}
}
