package com.etixpert.evolution.gui.servlets;

import org.hibernate.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import com.etixpert.evolution.*;
import java.util.*;


public class GUIRightsHelper {
	
	public static List getNavigationMenus(HttpSession session) throws Exception {
		org.apache.log4j.Logger log = MainControl.logger;
		Transaction tx = null;
		try {
			
			Session hibernateSession = HibernateUtil.currentSession();
			
			tx = hibernateSession.beginTransaction();
			
			List l = getNavigationMenus(hibernateSession, session);
			
			tx.commit();
			
			HibernateUtil.closeSession();
			return l;
		} catch (Exception e) {
			
			if (tx!=null) tx.rollback();
			HibernateUtil.closeSession();
			throw e;
		}
		
		
	}
	
	public static List getNavigationMenus(Session hibernateSession, HttpSession session) throws Exception{
		org.apache.log4j.Logger log = MainControl.logger;
		Integer lid = new Integer((String) session.getAttribute("USER_LOGGED_LEVEL_ID"));
		
		
		
		
		Query q = hibernateSession.createQuery("select menus from UserRole r join r.menus menus where r=:lid and  menus.type<>3 order by menus.pos");
		
		q.setParameter("lid", lid);
		List l = q.list();
		
		
		return l;
	}
	
	public static String getPos(int id) throws Exception {
		ObjectSearch os = new ObjectSearch("menus", "id");
		os.setCondition("id = ?");
		List result = os.search(new Object[] {new Integer(id)});
		if (result.size()==0) return "";
		PersistableObject po = (PersistableObject)result.get(0);
		return po.getString("pos", "");
	}
	
	public static String generateTabbedMenus(PageContext pc, int self, int parent, boolean showBonus) throws Exception {
		HttpSession session = pc.getSession();
		List l = getTabbedMenus(session, parent, showBonus);
		StringBuffer sb = new StringBuffer();
		sb.append("<tr>");
		
		for (int i = 0; i<l.size(); i++) {
			Menu m = (Menu)l.get(i);
			int id = m.getId();
			String tdstr = "<td id=\"userTableContent\">";
			String link = m.getLink(session);
			String name = m.getName(pc);
			String linkstr = "<a href=\""+link+"\">"+name+"</a>";
			
			if (self == id) {
				tdstr = "<td id=\"userSelectedTableContent\" class=\"menu2\">";
				linkstr=name;
			}
			
			sb.append(tdstr+linkstr+"</td>");
			
		}
		
		sb.append("</tr>");
		return sb.toString();
	}
	
	
	public static List getTabbedMenus(HttpSession session, int parent, boolean showBonus) throws Exception {
		Transaction tx = null;
		try {
			
			Session hibernateSession = HibernateUtil.currentSession();
			tx = hibernateSession.beginTransaction();
			List l = getTabbedMenus(hibernateSession, session, parent, showBonus);
			tx.commit();
			HibernateUtil.closeSession();
			return l;
		} catch (Exception e) {
			if (tx!=null) tx.rollback();
			HibernateUtil.closeSession();
			throw e;
		}
	}
	
	public static List getTabbedMenus(Session hibernateSession, HttpSession session, int parent, boolean showBonus) {
		Integer lid = new Integer((String) session.getAttribute("USER_LOGGED_LEVEL_ID"));
		String added = "";
		if (!showBonus) added = " and menus.id <> 1260";
		Query q = hibernateSession.createQuery("select menus from UserRole r join r.menus menus where r=:lid and menus.type=3 and menus.parent=:parent" + added + " order by menus.pos");
		q.setParameter("lid", lid);
		q.setInteger("parent", parent);
		List l = q.list();
		return l;
	}
	
	public static boolean isJspAllowed(HttpSession session, String jsp) throws Exception {
		
		Transaction tx = null;
		try {
			
			Session hibernateSession = HibernateUtil.currentSession();
			tx = hibernateSession.beginTransaction();
			boolean b = isJspAllowed(hibernateSession, session, jsp);
			tx.commit();
			HibernateUtil.closeSession();
			return b;
		} catch (Exception e) {
			if (tx!=null) tx.rollback();
			HibernateUtil.closeSession();
			throw e;
		}
	}
	
	public static boolean isJspAllowed(Session hibernateSession, HttpSession session, String jsp) {
		Integer lid = new Integer((String) session.getAttribute("USER_LOGGED_LEVEL_ID"));
		return isJspAllowed(hibernateSession, lid, jsp); 	
	}
	
	public static boolean isJspAllowed(Session hibernateSession, Integer role, String jsp) {
		Query q = hibernateSession.createQuery("select jsps from UserRole r join r.jsps jsps where r=:lid and jsps.name=:jsp");
		q.setParameter("lid", role).setParameter("jsp",jsp);
		return q.list().size()>0;
	
	}
}

