/*
 * 
 * Created on Jun 6, 2005
 * 
 * Gy�rgy S�veges
 * Etixpert Kft.
 * Copyright(c) 2005
 * 
 */
package com.etixpert.evolution.gui.servlets.elements;

import javax.servlet.http.HttpSession;
import java.util.*;
import java.sql.*;
import com.etixpert.evolution.*;
import javax.servlet.jsp.jstl.fmt.*;

/**
 * @author Suveges Gyorgy
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class CheckBox extends FormElement {
    protected String text;
    protected boolean checked;
    /**
     * @param session
     * @param jspSite
     * @param key
     */
    public CheckBox(HttpSession session, String jspSite, String key, String value, String text, boolean checked) {
        super(session, jspSite, key);
        this.addProperty("value", value);
        this.text = text;
        this.checked = checked;
       
    }

   public static CheckBox[] generateFromLookup(Connection conn, HttpSession session, String jspSite, String table, String key, String keyField, String textField, boolean allChecked) throws Exception {
       ObjectSearch os = new ObjectSearch();
       os.setTable(table);
       if (table.equals("payment_method"))
    	   os.setCondition("id<>5");
       
       List l = os.search(conn);
       int size = l.size();
      // if (table.equals("payment_method") && l.size()==6) size = 5;
       CheckBox[] chkbxs = new CheckBox[size];
       for (int i =0; i < size; i++) {
       		PersistableObject po = (PersistableObject) l.get(i);
       		//if (po.getString("id", "0").equals("5")) continue;
       		chkbxs[i] = new CheckBox(session, jspSite, key, po.getString(keyField,""), po.getString(textField,""), allChecked);
       }
   
       return chkbxs;
   }
    
   public static CheckBox[] generateSpecial(Connection conn, HttpSession session, String jspSite, boolean allChecked) throws Exception {
    ObjectSearch os = new ObjectSearch();
    os.setTable("payment_method");
    os.setCondition("id in (1, 2)");
    os.setOrderBy(new String[] {"id"});
    List l = os.search(conn);
    CheckBox[] chkbxs = new CheckBox[2];
    //primitive solution
    for (int i =0; i < l.size(); i++) {
        PersistableObject po = (PersistableObject) l.get(i);
        chkbxs[i] = new CheckBox(session, jspSite, "payment_method_id", po.getString("id",""), po.getString("descr",""), allChecked);
    }

    return chkbxs;   	
   }
   
   public String getValue(String defaultValue) {
       if (isChecked()) return getProperty("value");
       else return "";

   } 
  
    public boolean isChecked() {
        if (!keepState) return checked;
        Map m = (Map) session.getAttribute(jsp);
        if (m==null) return checked;
        String[] s = (String[]) m.get(key);
        if (s==null || s.length==0) return  false;
        for (int i=0; i<s.length; i++) {
        	
            if (s[i].equalsIgnoreCase(this.getProperty("value")))
                return true;
        }
        
        return false;
        
    }
    
  
    /* (non-Javadoc)
     * @see com.etixpert.evolution.gui.servlets.elements.FormElement#toHTML()
     */
    public String toHTML() throws Exception {
        // TODO Auto-generated method stub
    	
        return "<input type=\"checkbox\" name=\""+key+"\" "+propertiesToHTML() + (isChecked()?" checked>":">")+
        		(localize?LocaleSupport.getLocalizedMessage(pageContext,text):text)+"</input>\n";
    }

    
}
