/*
 * 
 * Created on Jun 4, 2005
 * 
 * Gy�rgy S�veges
 * Etixpert Kft.
 * Copyright(c) 2005
 * 
 */
package com.etixpert.evolution.gui.servlets.elements;


import java.util.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;

/**
 * 
 * 
 * @author Suveges Gyorgy
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public abstract class FormElement {
    protected String jsp;
    protected HttpSession session;
    protected Map properties = new HashMap();
    protected String key;
    protected String defaultValue="";
    protected boolean disabled = false;
    protected boolean keepState = true;
    protected PageContext pageContext = null;
    protected boolean localize = false;
    
    /**
     * @return Returns the disabled.
     */
    public boolean isDisabled() {
        return disabled;
    }
    /**
     * @param disabled The disabled to set.
     */
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }
    /**
     * @return Returns the defaultValue.
     */
    public String getDefaultValue() {
        return defaultValue;
    }
    /**
     * @param defaultValue The defaultValue to set.
     */
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }
    
    public FormElement(HttpSession session, String jspSite, String key) {
        this.session = session;
        this.jsp = jspSite;
        this.key = key;
        this.defaultValue = "";
        // TODO Auto-generated constructor stub
    }    
    
    /**
     * 
     */
    public FormElement(HttpSession session, String jspSite, String key, String defaultValue) {
        this(session, jspSite, key);
        this.defaultValue = defaultValue;
        // TODO Auto-generated constructor stub
    }
    
    
    public static void addProperties(FormElement[] elements, Map properties) {
        for (int i=0; i<elements.length; i++) {
           Iterator it = properties.keySet().iterator();
           while (it.hasNext()) {
               String key = (String) it.next();
               String value = (String) properties.get(key);
               elements[i].addProperty(key, value);
           }
         }
    }

    /**
     * @return Returns the jsp.
     */
    public String getJsp() {
        return jsp;
    }
    /**
     * @param jsp The jsp to set.
     */
    public void setJsp(String jsp) {
        this.jsp = jsp;
    }
    /**
     * @return Returns the events.
     */
    public Map getProperties() {
        return properties;
    }
    /**
     * @param events The events to set.
     */
    public void setEvents(Map properties) {
        this.properties = properties;
    }
    
    public void addProperty(String name, String value) {
        if (value==null || name==null ) return;
        properties.put(name, value);
    }
    
    public void setProperty(String name, String value) {
        addProperty(name, value);
    }
    public String getProperty(String name) {
        return (String) properties.get(name);
    }
    
    
    public abstract String toHTML() throws Exception;
    
    public String toString()  {
       try { 
        return toHTML();
       } catch(Exception e) {
           return "";
       }
    }
    
    public boolean hasDefaultValue() {
        if (key == null || session == null) return false;
        Map m = (Map) session.getAttribute(jsp);
        if (m==null) return false;
        String[] s = (String[]) m.get(key);
        if (s==null || s.length==0 || s[0]==null) return false;
        return true;
        
        
        
    }
    
    public String getValue() {
      return getValue(defaultValue);
    }
    
    public String getValue(String defaultValue) {
        if (!keepState) return defaultValue;
        if (!hasDefaultValue()) return defaultValue;
        else {
            String[] s = (String []) ((Map) session.getAttribute(jsp)).get(key);
            return s[0];
        }
    }
    
    
    /**
     * @return Returns the key.
     */
    public String getKey() {
        return key;
    }
    /**
     * @param key The key to set.
     */
    public void setKey(String key) {
        this.key = key;
    }
    /**
     * @return Returns the session.
     */
    public HttpSession getSession() {
        return session;
    }
    /**
     * @param session The session to set.
     */
    public void setSession(HttpSession session) {
        this.session = session;
    }
    
    protected String propertiesToHTML() {
        StringBuffer sb = new StringBuffer();
       
        Iterator it = properties.keySet().iterator();
        while (it.hasNext()) {
            String key = (String) it.next();
            sb.append(key).append("=\"");
            String handler = (String) properties.get(key);
            sb.append(handler).append("\" ");
        }
      if (disabled) sb.append(" DISABLED ");
        return sb.toString();
    }
    /**
     * @param saveState The saveState to set.
     */
    public void setKeepState(boolean saveState) {
        this.keepState = saveState;
    }

	public void setLocalize(boolean localize) {
		this.localize = localize;
	}
	public PageContext getPageContext() {
		return pageContext;
	}
	public void setPageContext(PageContext pageContext) {
		this.pageContext = pageContext;
	}
}
