/*
 * 
 * Created on Aug 2, 2005
 * 
 * György Süveges
 * Etixpert Kft.
 * Copyright(c) 2005
 * 
 */
package com.etixpert.evolution.gui.servlets.elements;

import javax.servlet.http.*;
import com.etixpert.evolution.*;


import java.sql.*;
import java.util.*;


/**
 * @author Suveges Gyorgy
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class QuerySelect extends Select {
    private ObjectSearch os;
    private Connection conn;
    private String keyField;
    private String valueField;
    private String query;
    private Object[] parameters;
    private Iterator it;
    
    /**
     * @param session
     * @param jspSite
     * @param key
     */
    public QuerySelect(HttpSession session, String jspSite, String key, ObjectSearch os, String keyField, String valueField) {
        super(session, jspSite, key);
        this.keyField = keyField;
        this.valueField = valueField;
        this.os = os;
        
    }

    /**
     * @param session
     * @param jspSite
     * @param key
     * @param defaultValue
     */
    public QuerySelect(HttpSession session, String jspSite, String key, ObjectSearch os, String keyField, String valueField,
            String defaultValue) {
        super(session, jspSite, key, defaultValue);
        this.keyField = keyField;
        this.valueField = valueField;
        this.os = os;
    }

    /* (non-Javadoc)
     * @see com.etixpert.evolution.gui.servlets.elements.Select#reset()
     */
    protected void reset() throws Exception {
        List l = null;
        if (conn==null && query!=null)
            l = os.search(query, parameters);
        else if (conn==null && query==null)
            l = os.search();
        else if (conn!=null && query!=null)
            l = os.search(conn, query, parameters);
        else
            l = os.search(conn);
        
        it = l.iterator();
        

    }

    /* (non-Javadoc)
     * @see com.etixpert.evolution.gui.servlets.elements.Select#hasNext()
     */
    protected boolean hasNext() throws Exception {
      return it.hasNext();
    }

    /* (non-Javadoc)
     * @see com.etixpert.evolution.gui.servlets.elements.Select#next()
     */
    protected String[] next() throws Exception {
        // TODO Auto-generated method stub
        String [] pair = new String[2];
        PersistableObject po = (PersistableObject) it.next();
        pair[0] = po.getString(keyField, "");
        String[] values = valueField.split(",");
        String value="";
        for (int i=0; i<values.length; i++) {
            if (i>0)  value+=" ";
            value+=po.getString(values[i], "");
        }
        pair[1] = value;
        return pair;
            
    }
    
    public void setConnection(Connection conn) {
        this.conn = conn;
    }
    
    public void setQuery(String query) {
        this.query = query;
    }
    
    public void setQuery(String query, Object[] parameters) {
        setQuery(query);
        this.parameters = parameters;
        
    }

}
