/*
 * 
 * Created on Jun 28, 2005
 * 
 * György Süveges
 * Etixpert Kft.
 * Copyright(c) 2005
 * 
 */
package com.etixpert.evolution.gui.servlets.pageactions;

import javax.servlet.http.*;
import com.etixpert.evolution.app.utils.*;

/**
 * @author Suveges Gyorgy
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public abstract class PDFLinker extends PageActionHandler {

    /**
     * 
     */
    public PDFLinker() {
        super();
        // TODO Auto-generated constructor stub
    }

    /* (non-Javadoc)
     * @see com.etixpert.evolution.gui.servlets.pageactions.PageActionHandler#handle(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     */
    protected void handle(HttpServletRequest request,
            HttpServletResponse response) throws Exception {
        request.getSession().removeAttribute("forwardlink");
        response.setContentType("application/octet-stream");
		response.setHeader("Content-Disposition","attachment; filename=file.pdf");
        logger.info("getting each pdfs");
        byte[][] datas = getPDFs(request);
        if (datas==null) {
            logger.info("there is no pdf data to link");
            return;
            
        }
        logger.info("linking pdfs");
        byte[] result = PDFUtils.concatenate(datas);
        logger.info("linked pdfs generated");
        response.getOutputStream().write(result);
        sentToResponse=true;

    }
    
    
    protected abstract byte[][] getPDFs(HttpServletRequest req) throws Exception; 
    

}
