/*
 * 
 * Created on May 29, 2005
 * 
 * Gy�rgy S�veges
 * Etixpert Kft.
 * Copyright(c) 2005
 * 
 */


package com.etixpert.evolution.gui.servlets.pageactions;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import org.apache.log4j.*;
import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
/**
 * @author Suveges Gyorgy
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public abstract class PageActionHandler {
    protected Logger logger = Logger.getLogger("mainControl." + getPageAction());
    protected boolean sentToResponse = false; 
    protected PageContext pageContext;
    /**
     * 
     */
    public PageActionHandler() {
        super();
        // TODO Auto-generated constructor stub
    }
    
    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            handle(request, response);
        } catch (Exception e) {
            if (e instanceof ServletException)
                throw (ServletException) e;
            else {
                logger.error("Error handling page action",e);
                throw new ServletException(e.getMessage());
            }
                
        }
    }
    
    protected abstract void handle(HttpServletRequest request, HttpServletResponse response) throws Exception;
     
    
    public String getPageAction() {
        String clazz = this.getClass().getName();
        int i = clazz.lastIndexOf('.');
        if (i<0) return clazz;
        else return clazz.substring(i+1);
    }
    
    public boolean sentToResponse() {
        return sentToResponse;
    }
    
    public void setPageContext(PageContext pageContext) {
        this.pageContext = pageContext;
    }
    
    public static void changeBooleanValues(HttpServletRequest req, Map details, String prop) {
		 Set s = details.keySet();
		 Iterator it = s.iterator();
		 while (it.hasNext()) {
			 String pos = (String) it.next();
			 try {
				 int k = Integer.parseInt(pos);
				 Map row = (Map) details.get(pos);
				 if (req.getParameter(prop+pos)!=null)
					 row.put(prop, new String[]{"yes"});
				 else
					 row.put(prop, new String[]{""});
				 
			 } catch (Exception e) {
				 continue;
				 
			 }
			 
		 }
		 
		 
	 }
    
    public static void setBooleanValues(Map details, String prop) {
		 Set s = details.keySet();
		 Iterator it = s.iterator();
		 while (it.hasNext()) {
			 String pos = (String) it.next();
			 try {
				 int k = Integer.parseInt(pos);
				 Map row = (Map) details.get(pos);
					 row.put(prop, new String[]{"yes"});
				 
			 } catch (Exception e) {
				 continue;
				 
			 } 
		 }		 
	 }
    
}
