/*
 * File name  : CountryValue.java
 * Package    : com.etixpert.evolution.value
 * Created on : 11.11.2011
 * Created by : Laszlo Felfoldi (laszlo.felfoldi@etixpert.com)
 */
package com.etixpert.evolution.value;

import java.sql.Connection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import com.etixpert.evolution.ObjectSearch;
import com.etixpert.evolution.PersistableObject;

public class CountryValue extends Value {
	public CountryValue(PersistableObject po) {
		super();
		members.put("country_code", po.get("country_code"));
		members.put("name", po.get("name"));
	}
	
	public String getCountryCode() {
		return (String) get("country_code");
	}
	
	public String getName() {
		return (String) get("name");
	}
	
	public static Map getAll(Connection con) {
		Map ret = new Hashtable();
	    
	    // load all countries 
	    List items = null;
		ObjectSearch os = new ObjectSearch();
	    try {
	    	items = os.search(con, "select * From country");
	    } catch (Exception e) {
	    	e.printStackTrace(System.err);
	    }
	    
	    if (items != null){
	    	for (Iterator it = items.iterator(); it.hasNext(); ) {
	    		PersistableObject po = (PersistableObject) it.next();
	    	    
	    		// get a country
	    		if (!ret.containsKey(po.get("country_code"))) {
		    		CountryValue cv = new CountryValue(po);
		    		ret.put(cv.getCountryCode(), cv);
	    		}
	    	}
	    }
		return ret;
	}
	
	public String toString() {
		return members.toString();
	}
}
