/*
 * DistributorHistory.java
 * Created on May 16, 2005 
 * Author: 	L�szl� Felf�ldi, Etixpert GmbH
 * mail:	laszlo.felfoldi@etixpert.com		
 */
package com.etixpert.evolution.value.bonus;

import java.sql.Connection;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import com.etixpert.evolution.ObjectSearch;
import com.etixpert.evolution.PersistableObject;
import com.etixpert.evolution.app.bonus.BonusList;
import com.etixpert.evolution.value.Value;

public class DistributorHistoryValue extends Value {
	private Object id;
	private Object distrId;
	private Object levelId;
	private Date   from;
	private Date   to;
	
	public DistributorHistoryValue(Object aDistrId, Object aLevelId, Date aFrom, Date aTo) {
		id      = null;
		distrId = aDistrId;
		levelId = aLevelId;
		from    = aFrom;
		to      = aTo;
	}
	
	public Object getId() {
	    return id;
	}
	
	public Object getLevelId() {
	    return levelId;
	}
	
	public void insert(Connection conn) throws Exception {
		PersistableObject po = new PersistableObject("distributor_history", "distr_hist_id");
		po.set("distr_id", distrId);
		po.set("level_id", levelId);
		po.set("level_from", new java.sql.Date(from.getTime()));
		po.set("level_to", new java.sql.Date(to.getTime()));
		po.insert(conn);
	}
	
	public void insert(Connection conn, boolean update) throws Exception {
		PersistableObject po = new PersistableObject("distributor_history", "distr_hist_id");
		po.set("distr_id", distrId);
		po.set("level_id", levelId);
		po.set("level_from", new java.sql.Date(from.getTime()));
		po.set("level_to", new java.sql.Date(to.getTime()));
		po.insert(conn, update);
		if (update) id = po.get("distr_hist_id");
	}
	
	public static Map getByMonthLevelId(Connection conn, Date month, Integer levelId) {
	    ObjectSearch os = new ObjectSearch();
	    
	    Date smonth = BonusList.getMonthBegin(month).getTime();
	    Calendar eCal = Calendar.getInstance();
	    eCal.setTime(smonth);
	    eCal.add(Calendar.MONTH, 1);
	    Date emonth = eCal.getTime();
	    
	    try {
	        List items = os.search(conn, 
	            "Select * from distributor_history dh1 Where level_from between ? And ? " +
	            "And Level_Id <> (Select Max(dh2.Level_Id) From distributor_history dh2 " +
	            "Where dh2.distr_id=dh1.distr_id And level_to < ?) " +
	            (levelId != null ? "And Level_Id=?": ""),
	            levelId == null ? 
	                new Object[] {new java.sql.Date(smonth.getTime()), 
	                	new java.sql.Date(emonth.getTime() - 1), 
	                	new java.sql.Date(emonth.getTime() - 1)} :
   	                new Object[] {new java.sql.Date(smonth.getTime()), 
   	                	new java.sql.Date(emonth.getTime() - 1), 
   	                	new java.sql.Date(emonth.getTime() - 1),
   	                	levelId}
	        );
	        
	        Map ret = new Hashtable();
	        for (Iterator it = items.iterator(); it.hasNext(); ) {
	            PersistableObject po = (PersistableObject) it.next();
	            ret.put(po.get("distr_id"), 
	                    (new DistributorHistoryValue(po.get("distr_id"), po.get("level_id"), 
	                            (Date) po.get("level_from"), (Date) po.get("level_to"))));
	        }
	        return ret;
	        
	    } catch (Exception e) {
	        e.printStackTrace(System.err);
	    }
		return null;
	}
}
