/*
 * IndividualBonusValue.java
 * Created on 2005.06.05.
 * Author:  Laszlo Felfoldi, Etixpert GmbH 
 * mail:    laszlo.felfoldi@etixpert.com
 */
package com.etixpert.evolution.value.bonus;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import com.etixpert.evolution.ObjectSearch;
import com.etixpert.evolution.PersistableObject;
import com.etixpert.evolution.value.Value;

public class IndividualBonusValue extends Value {
	private String description;
	private Date   validFrom;
	private Date   validTo;
	private String qMetric;
	private int    qType;
	private double qValue;
	private String calcMetric;
	private int    calcType;
	private double calcValue;
	private int    calcValueType;
	
	public IndividualBonusValue(String aDescription, Date aValidFrom, Date aValidTo, 
			String aQMteric, int aQType, double aQValue,
			String aCalcMetric, int aCalcType, double aCalcValue, int aCalcValueType) {
		description = aDescription;
		validFrom = aValidFrom;
		validTo = aValidTo;
		qMetric = aQMteric;
		qType = aQType;
		qValue = aQValue;
		calcMetric = aCalcMetric;
		calcType = aCalcType;
		calcValue = aCalcValue;
		calcValueType = aCalcValueType;
	}
	
	public Date getValidFrom() {
		return validFrom;
	}
	
	public Date getValidTo() {
		return validTo;
	}
	
	public String getQMetric() {
		return qMetric;
	}
	
	public int getQType() {
		return qType;
	}

	public double getQValue() {
		return qValue;
	}
		
	public String getCalcMetric() {
		return calcMetric;
	}
	
	public int getCalcType() {
		return calcType;
	}
	
	public double getCalcValue() {
		return calcValue;
	}
	
	public int getCalcValueType() {
		return calcValueType;
	}
	
	public String getDescription() {
		return description;
	}
	
	public static IndividualBonusValue getFromPO(PersistableObject po) {
		Map val = po.getValues();
		IndividualBonusValue ibv = new IndividualBonusValue(
				(String) val.get("descr"), (Date) val.get("valid_from"), (Date) val.get("valid_to"),
				(String) val.get("q_metric"), ((Integer) val.get("q_type")).intValue(), ((BigDecimal) val.get("q_value")).doubleValue(),
				(String) val.get("calc_metric"), ((Integer) val.get("calc_type")).intValue(), ((BigDecimal) val.get("calc_value")).doubleValue(),
				((Integer) val.get("calc_value_type")).intValue()
		);
		return ibv;
	}
	
	public static List getByDistId(Connection con, Object distrId) {
		List ret = new LinkedList();
        
		// load from the database
        List items = null;
		ObjectSearch os = new ObjectSearch();
        try {
        	items = os.search(con, 
        			"select * from individual_bonus Where distr_id=? Order By valid_to Desc", new Object[] {distrId});
        } catch (Exception e) {
        	e.printStackTrace(System.err);
        }
        		
		if (items != null){
        	for (Iterator it = items.iterator(); it.hasNext(); ) {
        		// get a record
        		PersistableObject po = (PersistableObject) it.next();
        		IndividualBonusValue ibv = getFromPO(po);
				ret.add(ibv);		
        	}
        }
		return ret;
	}
}
