/*
 * OrderDetails.java
 * Created on Apr 30, 2005 
 * Author: 	L�szl� Felf�ldi, Etixpert GmbH
 * mail:	laszlo.felfoldi@etixpert.com		
 */
package com.etixpert.evolution.value.order;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import org.jdom2.Element;

import com.etixpert.evolution.ObjectSearch;
import com.etixpert.evolution.PersistableObject;
import com.etixpert.evolution.value.Value;

import java.math.BigDecimal;
import java.sql.*;

public class OrderDetailsValue extends Value {
	private Object id;
	private String name;
	private int    quantity;
	private double netto;
	private double brutto;
	private double bonus;
	private double nettoTrader;
	private double bruttoTrader;
	private double vat;
	private double tradeMargin;
	
	public OrderDetailsValue(Object aId, String aName, int aQuantity, 
			double aNetto, double aNettoTrader, double aBrutto, double aBruttoTrader, 
			double aBonus, double aVat, double aTradeMargin) {
		id = aId;
		name = aName;
		quantity = aQuantity;
		netto = aNetto;
		nettoTrader = aNettoTrader;
		brutto = aBrutto;
		bruttoTrader = aBruttoTrader;
		bonus = aBonus;
		vat = aVat;
		tradeMargin = aTradeMargin;
	}
		
	public double getNetto() {
		return netto;
	}
	
	public double getBonus() {
		return bonus;
	}

	public int getQuantity() {
		return quantity;
	}
	
	public double getVat() {
		return vat;
	}
	
	public double getTradeMargin() {
		return tradeMargin;
	}
	
	public void toXML(Element to) {
		Element e = new Element("item");
		e.setAttribute("AId",    "" + id);
		e.setAttribute("Name",   "" + name);
		e.setAttribute("Num",    "" + quantity);
		e.setAttribute("Netto",  "" + netto);
		e.setAttribute("NettoTrader",  "" + nettoTrader);
		e.setAttribute("Brutto", "" + brutto);
		e.setAttribute("BruttoTrader",  "" + bruttoTrader);
		e.setAttribute("Bonus",  "" + bonus);
		e.setAttribute("Vat",    "" + vat);
		e.setAttribute("TradeMargin",   "" + vat);
		to.addContent(e);
	}
	
	public static List getByOrderId(Connection conn, Object orderId) {
		List ret = new LinkedList();
        
        // load all distributors 
        List items = null;
		ObjectSearch os = new ObjectSearch();
        try {
        	items = os.search(conn, 
        			"select * from order_detail Where order_id = ? Order By art_position", 
					new Object[] {orderId});
        } catch (Exception e) {
        	e.printStackTrace(System.err);
        }
       		
		if (items != null){
        	for (Iterator it = items.iterator(); it.hasNext(); ) {
        		// get an order
        		PersistableObject po = (PersistableObject) it.next();
        		Map val = po.getValues();
        		
        		Double netto        = (Double) val.get("netto");
        		BigDecimal nettoTrader  = (BigDecimal) val.get("netto_trader");
        		BigDecimal brutto       = (BigDecimal) val.get("brutto");
        		BigDecimal bruttoTrader = (BigDecimal) val.get("brutto_trader");
        		Double bonus        = (Double) val.get("bonus");
        		Double vatValue     = (Double) val.get("vat_value");
        		Double tradeMargin  = (Double) val.get("trade_margin");
        		
        		OrderDetailsValue od = new OrderDetailsValue(
        				val.get("art_id"), (String) val.get("art_name"), ((Integer) val.get("quantity")).intValue(),
						netto != null ? netto.doubleValue() : 0, 
						nettoTrader != null ? nettoTrader.doubleValue() : 0, 
						brutto != null ? brutto.doubleValue() : 0,
						bruttoTrader != null ? bruttoTrader.doubleValue() : 0,
						bonus != null ? bonus.doubleValue() : 0,
						vatValue != null ? vatValue.doubleValue() : 0,
						tradeMargin != null ? tradeMargin.doubleValue() : 0
				);
        		ret.add(od);
        	}
        }
		return ret;
	}
}
