<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:decimal-format name="nf" decimal-separator="," grouping-separator="." /> 
  <xsl:output method="html" encoding="ISO-8859-1"/>

  <xsl:template match="/">
    <table>
      <tr>
        <th>Id</th>
        <th>Name</th>
        <th class="num">Anzahl</th>
        <th class="num">Netto</th>
        <th class="num">Bonus</th>
        <th class="num">Punkte</th>
      </tr>
      <xsl:apply-templates select="/*/section[@id='1']/item"/>
    </table>
    <br/>
    <table>
      <tr>
        <th>ArtNr.</th>
        <th class="num">Anzahl</th>
        <th class="num">Netto</th>
        <th class="num">Bonus</th>
        <th class="num">Punkte</th>
      </tr>
      <xsl:apply-templates select="/*/section[@id='2']/item"/>
    </table>


  </xsl:template>

  <xsl:template match="item">    
    <tr>
      <td><xsl:value-of select="@Id"/></td>
      <xsl:if test="@Name">
        <td><xsl:value-of select="@Name"/></td>
      </xsl:if>
      <td class="num"><xsl:value-of select="@TQuantity"/></td>
      <td class="num"><xsl:value-of select="format-number(@TNetto, '0,00', 'nf')"/></td>
      <td class="num"><xsl:value-of select="format-number(@TBonus, '0,00', 'nf')"/></td>
      <td class="num"><xsl:value-of select="format-number(@TPoints, '0,000', 'nf')"/></td>
    </tr>
  </xsl:template>

</xsl:stylesheet>
