<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:decimal-format name="nf" decimal-separator="," grouping-separator="." /> 
  <xsl:output method="html" encoding="ISO-8859-1"/>

  <xsl:template match="/">
    <table>
      <tr>
        <th>Name</th>
        <th class="num">Anzahl</th>
        <th class="num">Punkte</th>
        <th class="num">Bonus</th>
      </tr>
      <xsl:apply-templates select="/*/item"/>
    </table>

  </xsl:template>

  <xsl:template match="item">    
    <tr>
      <td>
        <xsl:for-each select="../ancestor::*">&#160;&#160;&#160;</xsl:for-each>
	<xsl:value-of select="@Id"/>&#160;<xsl:value-of select="@Name"/>
      </td>
      <td class="num"><xsl:value-of select="sum(descendant-or-self::*/@TQuantity)"/></td>
      <td class="num"><xsl:value-of select="format-number(sum(descendant-or-self::*/@TPoints), '0,000', 'nf')"/></td>
      <td class="num"><xsl:value-of select="format-number(sum(descendant-or-self::*/@TBonus), '0,00', 'nf')"/></td>
    </tr>
    <xsl:apply-templates select="item"/>
  </xsl:template>

</xsl:stylesheet>
