<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:decimal-format name="nf" decimal-separator="," grouping-separator="." /> 

  <xsl:template match="/">

    <table>
      <tr>
        <th colspan="2">&#160;</th>
        <th class="num">Bonuswert</th>
        <th class="num">Netto</th>
        <th class="num">MWSt</th>
        <th class="num">Brutto</th>
      </tr>
      <tr>
        <th colspan="2">Gesamtsummen</th>
        <xsl:variable name="src" select="/*/*/*"/>
        <td class="num"><xsl:value-of select="format-number(sum($src/@Bonus), '0,00', 'nf')"/></td>
        <td class="num"><xsl:value-of select="format-number(sum($src/@Netto), '0,00', 'nf')"/></td>
        <td class="num"><xsl:value-of select="format-number(sum($src/@Brutto) - sum($src/@Netto), '0,00', 'nf')"/></td>
        <td class="num"><xsl:value-of select="format-number(sum($src/@Brutto), '0,00', 'nf')"/></td>
      </tr>
      <xsl:apply-templates select="/*/distributor"/>
    </table>
  </xsl:template>

  <xsl:template match="distributor">
	  <tr><td colspan="6">&#160;</td></tr>
	  <tr>
	    <th colspan="2">Distributor:</th>
	    <td colspan="4"><xsl:value-of select="@Did"/>&#160;<xsl:value-of select="@Name"/></td>
	  </tr>
	  <tr>
	    <th colspan="2">Ort</th>
	    <td colspan="4"><xsl:value-of select="@City"/></td>
	  </tr>
	  <tr>
	    <th>Rech.Nr.</th>
	    <th>Datum </th>
	    <th class="num">Bonuswert</th>
	    <th class="num">Netto</th>
	    <th class="num">MWSt</th>
	    <th class="num">Brutto</th>
	  </tr>
	  <xsl:apply-templates select="item"/>
	  <tr>
	    <th colspan="2">Summen:</th>
	    <td class="num"><xsl:value-of select="format-number(sum(item/@Bonus), '0,00', 'nf')"/></td>
	    <td class="num"><xsl:value-of select="format-number(sum(item/@Netto), '0,00', 'nf')"/></td>
	    <td class="num"><xsl:value-of select="format-number(sum(item/@Brutto) - sum(item/@Netto), '0,00', 'nf')"/></td>
	    <td class="num"><xsl:value-of select="format-number(sum(item/@Netto), '0,00', 'nf')"/></td>
	  </tr>
  </xsl:template>

  <xsl:template match="item">
    <tr>
      <td><xsl:value-of select="@BillingId"/></td>
      <td><xsl:value-of select="@BillingDate"/></td>
      <td class="num"><xsl:value-of select="format-number(@Bonus, '0,00', 'nf')"/></td>
      <td class="num"><xsl:value-of select="format-number(@Netto, '0,00', 'nf')"/></td>
      <td class="num"><xsl:value-of select="format-number(@Brutto - @Netto, '0,00', 'nf')"/></td>
      <td class="num"><xsl:value-of select="format-number(@Brutto, '0,00', 'nf')"/></td>
    </tr>
  </xsl:template>

</xsl:stylesheet>
