<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:decimal-format name="nf" decimal-separator="," grouping-separator="." /> 

  <xsl:template match="/">

    <table>
      <tr>
        <th>Id</th>
        <th>Titel</th>
        <th>Name</th>
        <th>Land</th>
        <th>Plz</th>
        <th>Ort</th>
        <th>Strasse</th>
        <th>Beraterart</th>
        <th>Sponsor</th>
      </tr>
      <xsl:apply-templates select="/*/names/item"/>
    </table>
 
  </xsl:template>

  <xsl:template match="item">
    <xsl:variable name="LevelId" select="@LevelId"/>
    <tr>
      <td><xsl:value-of select="@Id"/></td>
      <td><xsl:value-of select="@L"/></td>
      <td><xsl:value-of select="@Name"/></td>
      <td><xsl:value-of select="@Country"/></td>
      <td><xsl:value-of select="@ZipCode"/></td>
      <td><xsl:value-of select="@City"/></td>
      <td><xsl:value-of select="@Street"/></td>
      <td><xsl:value-of select="/*/levels//item[@Id=$LevelId]/@Name"/></td>
      <td><xsl:value-of select="@Sponsor"/></td>
    </tr>
  </xsl:template>

</xsl:stylesheet>
