<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:decimal-format name="nf" decimal-separator="," grouping-separator="." /> 

  <xsl:template match="/">
    <table style="tabla-layout:fixed;">
      <tr>
        <th colspan="3">&#160;</th>
        <th class="num">Bonuswert</th>
        <th class="num">Netto</th>
        <th class="num">MWSt</th>
        <th class="num">Brutto</th>
      </tr>
      <tr>
        <th colspan="2">&#160;</th>
        <th colspan="1">Summen</th>
        <td class="num"><xsl:value-of select="format-number(sum(/*/*/@Bonus), '0,00', 'nf')"/></td>
        <td class="num"><xsl:value-of select="format-number(sum(/*/*/@Netto), '0,00', 'nf')"/></td>
        <td class="num"><xsl:value-of select="format-number(sum(/*/*/@Brutto) - sum(/*/*/@Netto), '0,00', 'nf')"/></td>
        <td class="num"><xsl:value-of select="format-number(sum(/*/*/@Brutto), '0,00', 'nf')"/></td>
      </tr>
      <tr>
        <th>Rech.Nr.</th>
        <th>Name</th>
        <th>Id</th>
        <th class="num">Bonuswert</th>
        <th class="num">Netto</th>
        <th class="num">MWSt</th>
        <th class="num">Brutto</th>
      </tr>
      <xsl:apply-templates select="/*/item"/>
    </table>

  </xsl:template>

  <xsl:template match="item">
    <tr>
      <td><xsl:value-of select="@BillingId"/></td>
      <td><xsl:value-of select="@Name"/></td>
      <td><xsl:value-of select="@Did"/></td>
      <td class="num"><xsl:value-of select="format-number(@Bonus, '0,00', 'nf')"/></td>
      <td class="num"><xsl:value-of select="format-number(@Netto, '0,00', 'nf')"/></td>
      <td class="num"><xsl:value-of select="format-number(@Brutto - @Netto, '0,00', 'nf')"/></td>
      <td class="num"><xsl:value-of select="format-number(@Brutto, '0,00', 'nf')"/></td>
    </tr>
  </xsl:template>

</xsl:stylesheet>
