<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:decimal-format name="nf" decimal-separator="," grouping-separator="." /> 
  <xsl:output method="html" encoding="ISO-8859-1"/>

  <xsl:template name="getTotal">
    <xsl:param name="pos" select="1"/>
    <xsl:param name="src"/>
    <xsl:choose>
      <xsl:when test="$src[$pos]">
        <xsl:variable name="further">
          <xsl:call-template name="getTotal">
            <xsl:with-param name="pos" select="$pos + 1"/>
            <xsl:with-param name="src" select="$src"/>
          </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="current" select="$src[$pos]"/>
        <xsl:value-of select="$further + $current/@Quantity * $current/@Price"/>
      </xsl:when>
      <xsl:otherwise>0</xsl:otherwise>
    </xsl:choose>
  </xsl:template>  

  <xsl:template match="/">
    <table>
      <tr>
        <th>&#160;</th>
        <th>ArtNr.</th>
        <th>Bezeichnung</th>
        <th class="num">Einkaufspreis</th>
        <th class="num">Stck</th>
        <th class="num">EK Gesamt</th>
      </tr>
      <tr>
        <th colspan="3"><div align="right">Total</div></th>
        <th>&#160;</th>
        <td class="num"><xsl:value-of select="sum(/*/item/@Quantity)"/></td>
        <xsl:variable name="val">
          <xsl:call-template name="getTotal"><xsl:with-param name="src" select="/*/item"/></xsl:call-template>
        </xsl:variable>
        <td class="num"><xsl:value-of select="format-number($val, '0,00', 'nf')"/></td>
      </tr>
      <xsl:apply-templates select="/*/item"/>
    </table>
  </xsl:template>

  <xsl:template match="item">    
    <tr>
      <td class="num"><xsl:value-of select="position()"/></td>
      <td><xsl:value-of select="@Id"/></td>
      <td><xsl:value-of select="@Name"/></td>
      <td class="num"><xsl:value-of select="format-number(@Price, '0,00', 'nf')"/></td>
      <td class="num"><xsl:value-of select="@Quantity"/></td>
      <td class="num"><xsl:value-of select="format-number(@Quantity * @Price, '0,00', 'nf')"/></td>
    </tr>
    <xsl:apply-templates select="item"/>
  </xsl:template>

</xsl:stylesheet>
